package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;


public class EmptyListConstructor extends Constant {
    
    private static final TVar A = Types.var(Kinds.STAR);

    public EmptyListConstructor() {
        super(Types.forAll(A, Types.list(A)));
    }
    
    @Override
    public void push(MethodBuilder mb) {
        mb.loadStaticField("java/util/Collections", "EMPTY_LIST", Constants.LIST);
    }
    
    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success,
            Label failure) {
        if(failure == null)
            throw new InternalCompilerError("List deconstruction may always fail");
        
        parameter.push(mb);
        mb.invokeInterface(Constants.LIST, "size", TypeDesc.INT, Constants.EMPTY_TYPEDESC_ARRAY);
        mb.ifZeroComparisonBranch(failure, "!=");
        mb.jump(success);
    }
    
    @Override
    public int constructorTag() {
        return 0;
    }
    
}
