package org.simantics.scl.compiler.elaboration.chr.relations;

import org.simantics.scl.compiler.elaboration.chr.CHRRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;

import gnu.trove.set.hash.THashSet;

public class ExternalCHRRelation implements CHRRelation {
    public final SCLRelation relation;

    public ExternalCHRRelation(SCLRelation relation) {
        this.relation = relation;
    }

    @Override
    public TVar[] getTypeVariables() {
        return relation.getTypeVariables();
    }

    @Override
    public Type[] getParameterTypes() {
        return relation.getParameterTypes();
    }

    @Override
    public TPred[] getTypeConstraints() {
        return relation.getTypeConstraints();
    }
    
    @Override
    public String toString() {
        return relation.toString();
    }
    
    @Override
    public String[] getFieldNames() {
        return relation.getFieldNames();
    }

    @Override
    public void collectEnforceEffects(THashSet<Type> effects) {
        effects.add(relation.getEnforceEffect());
    }

    @Override
    public void collectQueryEffects(THashSet<Type> effects) {
        effects.add(relation.getQueryEffect());
    }
}
