package org.simantics.scl.compiler.elaboration.chr.planning.items;

import org.simantics.scl.compiler.elaboration.chr.plan.CheckOp;
import org.simantics.scl.compiler.elaboration.chr.planning.PrePlanItem;
import org.simantics.scl.compiler.elaboration.chr.planning.QueryPlanningContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;

import gnu.trove.set.hash.TIntHashSet;

public class CheckPrePlanItem extends PrePlanItem {
    public Expression condition;
    public TIntHashSet variableSet;

    public CheckPrePlanItem(Expression condition, TIntHashSet variableSet, int secondaryPriority) {
        super(secondaryPriority);
        this.variableSet = variableSet;
        this.condition = condition;
        if(variableSet.isEmpty())
            primaryPriority = 0.0;
    }

    @Override
    public void initializeListeners(QueryPlanningContext context) {
        context.listen(variableSet, this);
    }

    @Override
    public void variableSolved(QueryPlanningContext context, int variableId) {
        variableSet.remove(variableId);
        if(variableSet.isEmpty()) {
            primaryPriority = 0.0;
            context.priorityQueue.adjust(this);
        }
    }
    
    @Override
    public void generate(QueryPlanningContext context) {
        context.addPlanOp(new CheckOp(location, condition));
        context.bind(variableSet);
    }
}
