package org.simantics.scl.compiler.dynamic;

import org.simantics.scl.compiler.types.Type;

public class SafeDynamic {
    public final Type type_;
    public final Object value;
    
    public SafeDynamic(Type type_, Object value) {
        this.type_ = type_;
        this.value = value;
    }

    public String toString() {
        return new StringBuilder().append("(SafeDynamic").append(" ").append((Object)this.type_).append(" ").append(this.value).append(")").toString();
    }
    
    public boolean equals(Object other) {
        if(this == other)
            return true;
        if(other == null || !other.getClass().equals(SafeDynamic.class))
            return false;
        SafeDynamic dyn = (SafeDynamic)other;
        return type_.equals(dyn.type_) && (value == null ? dyn.value == null : value.equals(dyn.value));
    }
    
    public int hashCode() {
        return 31*type_.hashCode()+(value==null ? -957171758 : value.hashCode());
    }
}
