package org.simantics.scl.compiler.constants.singletons;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class ListElement extends FunctionValue {    
    private static TVar A = Types.var(Kinds.STAR);
    public static final ListElement INSTANCE = new ListElement();
    
    private ListElement() {
        super(new TVar[] {A}, Types.NO_EFFECTS, A, Types.list(A), Types.INTEGER);
    }
    
    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        parameters[0].push(mb);
        parameters[1].push(mb);
        mb.invokeInterface("java/util/List", "get", TypeDesc.OBJECT, new TypeDesc[] {TypeDesc.INT});
        return getReturnType();
    }

    @Override
    public String toString() {
        return "get";
    }
}
