package org.simantics.scl.compiler.constants;

import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Types;

public class CharacterConstant extends Constant {
    char value;

    public CharacterConstant(char value) {
        super(Types.CHARACTER);
        this.value = value;
    }
    
    @Override
    public void push(MethodBuilder mb) {
        mb.loadConstant(value);
    }
    
    @Override
    public String toString() {
        return "'" + Character.toString(value) + "'";
    }
    
    public char getValue() {
        return value;
    }

    @Override
    public int hashCode() {
        return value;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CharacterConstant other = (CharacterConstant) obj;
        if (value != other.value)
            return false;
        return true;
    }
    
    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success,
            Label failure) {
        mb.push(parameter, Types.CHARACTER);
        mb.loadConstant(value);
        mb.ifComparisonBranch(failure, "!=", TypeDesc.CHAR);
        mb.jump(success);
    }
    
    @Override
    public int constructorTag() {
        return 0;
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return value;
    }
}
