/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.GeometryUtils;

public class SelectionPivotNode
extends G2DNode {
    private static final long serialVersionUID = 1382614767907193882L;
    public static final transient BasicStroke SELECTION_STROKE = new BasicStroke(1.0f, 2, 2, 10.0f);
    protected Point2D pivot = null;

    @INode.SyncField(value={"pivot"})
    public void setPivot(Point2D pivot) {
        this.pivot = pivot;
    }

    @Override
    public void render(Graphics2D g) {
        AffineTransform ot = g.getTransform();
        g.setColor(Color.RED);
        g.translate(this.pivot.getX(), this.pivot.getY());
        double scale = GeometryUtils.getScale(g.getTransform());
        double scaleRecip = 1.0 / scale;
        g.setStroke(GeometryUtils.scaleStroke(SELECTION_STROKE, (float)scaleRecip));
        double padding = 5.0 * scaleRecip;
        float d = (float)padding;
        GeneralPath p = new GeneralPath();
        p.moveTo(-d, 0.0f);
        p.lineTo(d, 0.0f);
        p.moveTo(0.0f, -d);
        p.lineTo(0.0f, d);
        g.draw(p);
        g.setTransform(ot);
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return new Rectangle2D.Double(this.pivot.getX() - 5.0, this.pivot.getY() - 5.0, 10.0, 10.0);
    }
}

