/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;

public class ClippingNode
extends G2DParentNode {
    private static final long serialVersionUID = -1064240485806430485L;
    protected Shape clipShape;

    @INode.SyncField(value={"clipShape"})
    public void setClip(Shape shape) {
        this.clipShape = shape;
    }

    public Shape getClip() {
        return this.clipShape;
    }

    @Override
    public void render(Graphics2D g2d) {
        Shape prevClip = g2d.getClip();
        try {
            g2d.setClip(this.clipShape);
            super.render(g2d);
        }
        finally {
            g2d.setClip(prevClip);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[clip shape=" + String.valueOf(this.clipShape) + "]";
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        if (this.clipShape == null) {
            return null;
        }
        return this.clipShape.getBounds2D();
    }
}

