package org.simantics.scenegraph.utils;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;

import org.simantics.scenegraph.ScenegraphUtils;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.utils.threads.IThreadWorkQueue;

public class G2DUtils {
	
	public static boolean isAccelerated(Graphics2D g2d) {
		GraphicsConfiguration config = g2d.getDeviceConfiguration();
		return config != null && config.getImageCapabilities().isAccelerated();
	}

	public static Function1<Object, Boolean> getMethodPropertyFunctionWithG2DRepaint(final IThreadWorkQueue queue, IG2DNode n, String propertyName) {
		Function1<Object, Boolean> fn = ScenegraphUtils.getMethodPropertyFunction(queue, n, propertyName);
		return new Function1<Object, Boolean>() {
			@Override
			public Boolean apply(Object obj) {
				boolean dispose = fn.apply(obj);
				n.repaint();
				return dispose;
			}
		};
		
	}
}
