/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes.connection;

import gnu.trove.map.hash.THashMap;

import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteTerminal;

/**
 * @author Tuukka Lehtonen
 */
public class RemoveLineAction {

    RouteGraph rg;
    RouteGraph rgc;
    RouteTerminal terminal;

    public RemoveLineAction(RouteGraph rg, RouteGraph rgc, RouteTerminal terminal) {
        this.rg = rg;
        this.rgc = rgc;
        this.terminal = terminal;
    }

    public RouteGraph getOriginalRouteGraph() {
        return rg;
    }

    public RouteGraph getRouteGraph() {
        return rgc;
    }

    /**
     * @param rg
     * @param l the route line to remove
     * @param x
     * @param y
     * @return the performed action or <code>null</code> if no action to perform
     */
    public static RemoveLineAction perform(RouteGraph rg, RouteLine line, double x, double y) {
        // Can't remove segments from connections that have only two terminals.
        if (rg.isSimpleConnection() || rg.getTerminals().size() <= 2)
            return null;

        THashMap<Object, Object> map = new THashMap<Object, Object>();
        RouteGraph rgc = rg.copy(map);
        RouteLine lc = (RouteLine) map.get(line);

        RouteTerminal terminal = lc.getTerminal();
        if (terminal == null)
            return null;

        rgc.disconnect(terminal);
        rgc.remove(terminal);

        return new RemoveLineAction(rg, rgc, terminal);
    }

}
