package org.simantics.scenegraph.g2d.nodes;

/**
 * @author Antti Villberg
 * @since 1.29.0
 */
public class TargetedSVGNodeAssignment extends SVGNodeAssignment {
	public Object singleElementKey;
	public TargetedSVGNodeAssignment(Object singleElementKey, String elementId, String attributeNameOrId, String value) {
		super(elementId, attributeNameOrId, value);
		this.singleElementKey = singleElementKey;
	}
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((singleElementKey == null) ? 0 : singleElementKey.hashCode());
		result = prime * result + ((attributeNameOrId == null) ? 0 : attributeNameOrId.hashCode());
		result = prime * result + ((elementId == null) ? 0 : elementId.hashCode());
		result = prime * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TargetedSVGNodeAssignment other = (TargetedSVGNodeAssignment) obj;
		if (singleElementKey == null) {
			if (other.singleElementKey != null)
				return false;
		} else if (!singleElementKey.equals(other.singleElementKey))
			return false;
		if (attributeNameOrId == null) {
			if (other.attributeNameOrId != null)
				return false;
		} else if (!attributeNameOrId.equals(other.attributeNameOrId))
			return false;
		if (elementId == null) {
			if (other.elementId != null)
				return false;
		} else if (!elementId.equals(other.elementId))
			return false;
		if (value == null) {
			if (other.value != null)
				return false;
		} else if (!value.equals(other.value))
			return false;
		return true;
	}
	
}