/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DRenderingHints;

/**
 * @author Tuukka Lehtonen
 */
public class BoundsNode extends G2DNode {

    public interface ResizeListener {
        void controlResized(Rectangle2D bounds);
    }

    private static final long serialVersionUID = -3215912248617879834L;

    private Rectangle2D       controlbounds    = new Rectangle();

    @SyncField("controlbounds")
    protected void setControlBounds(Rectangle2D r) {
        this.controlbounds = r.getBounds2D();
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        // This node performs no real rendering but returning null
        // guarantees that its render method will get called.
        return null;
    }

    public Rectangle2D getControlBounds() {
        return controlbounds;
    }

    @Override
    public void render(Graphics2D g2d) {
        Rectangle2D r = (Rectangle2D) g2d.getRenderingHint(G2DRenderingHints.KEY_CONTROL_BOUNDS);
        if (r != null) {
            if (!r.equals(controlbounds)) {
                //System.out.println("new control bounds: " + r);
                setControlBounds(r);
                controlResized(r);
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + " [controlbounds=" + controlbounds + "]";
    }

    private ResizeListener resizeListener = null;

    public void setResizeListener(ResizeListener listener) {
        this.resizeListener = listener;
    }

    @ServerSide
    public void controlResized(Rectangle2D bounds) {
        if (resizeListener != null && bounds != null)
            resizeListener.controlResized(bounds);
    }

}