/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.scenegraph.g2d.events;

/**
 * Key event
 * 
 * @see Event
 * @see java.awt.event.KeyEvent for Virtual Key (VK) codes
 */
public abstract class KeyEvent extends org.simantics.scenegraph.g2d.events.Event {

    private static final long serialVersionUID = 2802306097538088526L;

    /** Key ascii character */
    public final char         character;

    /**
     * AWT Key code
     * 
     * @see java.awt.event.KeyEvent
     */
    public final int          keyCode;

    /** AWT state mask */
    public final int          stateMask;

    public KeyEvent(Object context, long time, char character, int keyCode, int stateMask) {
        super(context, time);
        this.character = character;
        this.keyCode = keyCode;
        this.stateMask = stateMask;
    }

    public boolean hasAnyModifier(int mask) {
        return (stateMask & mask) != 0;
    }

    public boolean hasAllModifiers(int mask) {
        return (stateMask & mask) == mask;
    }

    /**
     * Returns whether or not the Shift modifier is down on this event.
     */
    public boolean isShiftDown() {
        return (stateMask & MouseEvent.SHIFT_MASK) != 0;
    }

    /**
     * Returns whether or not the Control modifier is down on this event.
     */
    public boolean isControlDown() {
        return (stateMask & MouseEvent.CTRL_MASK) != 0;
    }

    /**
     * Returns whether or not the Alt modifier is down on this event.
     */
    public boolean isAltDown() {
        return (stateMask & MouseEvent.ALT_MASK) != 0;
    }

    /**
     * Returns whether or not the Alt Graph modifier is down on this event.
     */
    public boolean isAltGraphDown() {
        return (stateMask & MouseEvent.ALT_GRAPH_MASK) != 0;
    }

    public static class KeyPressedEvent extends KeyEvent {
        private static final long serialVersionUID = -648528900110788474L;

        public KeyPressedEvent(Object context, long time, char character, int keyCode, int stateMask) {
            super(context, time, character, keyCode, stateMask);
        }

        @Override
        public String toString() {
            return "Key press: character='" + character + "', keyCode='" + keyCode + "', stateMask='" + stateMask + "'";
        }
    }

    public static class KeyReleasedEvent extends KeyEvent {
        private static final long serialVersionUID = -5434711507289906052L;

        public KeyReleasedEvent(Object context, long time, char character, int keyCode, int stateMask) {
            super(context, time, character, keyCode, stateMask);
        }

        @Override
        public String toString() {
            return "Key release: character='" + character + "', keyCode='" + keyCode + "', stateMask='" + stateMask + "'";
        }
    }

}
