/*******************************************************************************
 * Copyright (c) 2021 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.color;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ColorFilterStack implements ColorFilter {
    private List<ColorFilter> colorFilters = new ArrayList<>(2);

    public void addColorFilter(ColorFilter colorFilter) {
        colorFilters.add(colorFilter);
    }

    @Override
    public Color filter(Color c) {
        for (ColorFilter f : colorFilters) {
            c = f.filter(c);
        }
        return c;
    }

    @Override
    public int hashCode() {
        return Objects.hash(colorFilters);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (!(obj instanceof ColorFilterStack))
            return false;
        ColorFilterStack other = (ColorFilterStack) obj;
        return Objects.equals(colorFilters, other.colorFilters);
    }
}
