/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d;

import java.awt.Component;

public class G2DFocusManager {
	public static G2DFocusManager INSTANCE = new G2DFocusManager();
	
	protected Component focus = null;
	
	private G2DFocusManager() {
	}
	
	public void markFocus(Component component) {
		focus = component;
	}
	
	public void clearFocus() {
		focus = null;
	}
	
	public Component getFocusOwner() {
		return focus;
	}
}
