/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.utils;

import java.util.ArrayList;
import java.util.Collections;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.IsEnumeratedValue;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.scl.CompileProceduralSCLMonitorRequest;
import org.simantics.modeling.scl.CompileSCLMonitorRequest;
import org.simantics.modeling.utils.ComponentTypePropertiesResult;
import org.simantics.modeling.utils.ComponentTypeViewerPropertyInfo;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.ui.ErrorLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadlessComponentTypePropertiesResultRequest
extends UniqueRead<ComponentTypePropertiesResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadlessComponentTypePropertiesResultRequest.class);
    protected final Resource componentType;

    public HeadlessComponentTypePropertiesResultRequest(Resource componentType) {
        this.componentType = componentType;
    }

    protected void readSectionSpecificData(ReadGraph graph, ComponentTypeViewerPropertyInfo info) throws DatabaseException {
    }

    public static ComponentTypeViewerPropertyInfo readPropertyInfo(ReadGraph graph, Resource relation, Resource componentType, boolean typeIsImmutable) throws DatabaseException {
        String description;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        StructuralResource2.getInstance((ReadGraph)graph);
        String name = (String)graph.getRelatedValue(relation, L0.HasName);
        String type = (String)graph.getPossibleRelatedValue(relation, L0.RequiresValueType);
        String label = (String)graph.getPossibleRelatedValue(relation, L0.HasLabel);
        if (label == null) {
            label = "";
        }
        if ((description = (String)graph.getPossibleRelatedValue(relation, L0.HasDescription)) == null) {
            description = "";
        }
        NumberType numberType = null;
        if (type == null) {
            type = "Double";
        }
        String unit = (String)graph.getPossibleRelatedValue(relation, L0X.HasUnit, (Binding)Bindings.STRING);
        Object defaultValue = "0";
        String expression = null;
        if (componentType != null) {
            for (Resource assertion : graph.getAssertedObjects(componentType, relation)) {
                try {
                    expression = (String)graph.getPossibleRelatedValue(assertion, L0.SCLValue_expression, (Binding)Bindings.STRING);
                    if (expression != null) {
                        defaultValue = "=" + expression;
                        continue;
                    }
                    if (((Boolean)graph.sync((ReadInterface)new IsEnumeratedValue(assertion))).booleanValue()) {
                        defaultValue = CommonDBUtils.getEnumerationValueName((ReadGraph)graph, (Resource)assertion);
                        continue;
                    }
                    Datatype dt = HeadlessComponentTypePropertiesResultRequest.getPossibleDatatype(graph, assertion);
                    if (dt == null) continue;
                    if (dt instanceof NumberType) {
                        numberType = (NumberType)dt;
                    }
                    Binding binding = Bindings.getBinding((Datatype)dt);
                    Object value = graph.getValue(assertion, binding);
                    try {
                        defaultValue = binding.toString(value, true);
                    }
                    catch (BindingException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                }
                catch (DatabaseException e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
            }
        }
        String valid = expression != null ? HeadlessComponentTypePropertiesResultRequest.validateMonitorExpression((RequestProcessor)graph, componentType, relation, expression) : null;
        boolean immutable = typeIsImmutable || graph.isImmutable(relation);
        ComponentTypeViewerPropertyInfo info = new ComponentTypeViewerPropertyInfo(relation, name, type, (String)defaultValue, numberType, unit, label, description, expression, valid, immutable);
        return info;
    }

    public ComponentTypePropertiesResult perform(ReadGraph graph) throws DatabaseException {
        ArrayList<ComponentTypeViewerPropertyInfo> result = new ArrayList<ComponentTypeViewerPropertyInfo>();
        ArrayList<NamedResource> connectionPoints = new ArrayList<NamedResource>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        boolean typeIsImmutable = graph.isImmutable(this.componentType) || graph.hasStatement(this.componentType, STR.ComponentType_Locked) || Layer0Utils.isPublished((ReadGraph)graph, (Resource)this.componentType) || Layer0Utils.isContainerPublished((ReadGraph)graph, (Resource)this.componentType);
        for (Resource relation : graph.getObjects(this.componentType, L0.DomainOf)) {
            if (graph.isSubrelationOf(relation, L0.HasProperty)) {
                ComponentTypeViewerPropertyInfo info = HeadlessComponentTypePropertiesResultRequest.readPropertyInfo(graph, relation, this.componentType, typeIsImmutable);
                this.readSectionSpecificData(graph, info);
                result.add(info);
                continue;
            }
            if (!graph.isInstanceOf(relation, STR.ConnectionRelation)) continue;
            NamedResource nr = new NamedResource(NameUtils.getSafeName((ReadGraph)graph, (Resource)relation), relation);
            connectionPoints.add(nr);
        }
        Collections.sort(result);
        return new ComponentTypePropertiesResult(result, connectionPoints, typeIsImmutable);
    }

    private static Datatype getPossibleDatatype(ReadGraph graph, Resource literal) throws DatabaseException {
        Binding binding = Bindings.getBindingUnchecked(Datatype.class);
        for (Resource dataTypeResource : graph.getObjects(literal, Layer0.getInstance((ReadGraph)graph).HasDataType)) {
            Datatype dt = (Datatype)graph.getPossibleValue(dataTypeResource, binding);
            if (dt == null) continue;
            return dt;
        }
        return null;
    }

    public static String validateMonitorExpression(RequestProcessor processor, final Resource componentType, final Resource relation, final String expression) {
        try {
            return (String)processor.sync((ReadInterface)new UniqueRead<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                    PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(relation), (AsyncProcedure)TransientCacheAsyncListener.instance());
                    StandardGraphChildVariable parent = new StandardGraphChildVariable(null, null, componentType){

                        public Resource getType(ReadGraph graph) throws DatabaseException {
                            return componentType;
                        }

                        public Variable getPossibleProperty(ReadGraph graph, String name) throws DatabaseException {
                            Variable prop = super.getPossibleProperty(graph, name);
                            if (prop != null) {
                                return prop;
                            }
                            return this.getChild(graph, name);
                        }
                    };
                    for (Resource literal : graph.getAssertedObjects(componentType, relation)) {
                        try {
                            StandardGraphPropertyVariable context = new StandardGraphPropertyVariable((Variable)parent, null, null, info, literal);
                            if (graph.isInstanceOf(componentType, STR.ProceduralComponentType)) {
                                CompileProceduralSCLMonitorRequest.compileAndEvaluate(graph, (Variable)context);
                                continue;
                            }
                            HeadlessComponentTypePropertiesResultRequest.compileAndEvaluate(graph, (Variable)context, expression);
                        }
                        catch (Exception e) {
                            String msg = e.getMessage();
                            int index = msg.indexOf(":");
                            if (index > 0) {
                                msg = msg.substring(index);
                            }
                            return msg;
                        }
                    }
                    return null;
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Could not validate ", (Throwable)e);
            return null;
        }
    }

    public static void compileAndEvaluate(ReadGraph graph, Variable context, String expression) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get((Object)"graph");
        try {
            try {
                ValidationCompilationRequest compileSCLMonitorRequest = new ValidationCompilationRequest(graph, context, expression);
                Function1 cfr_ignored_0 = (Function1)graph.syncRequest((Read)compileSCLMonitorRequest);
                sclContext.put((Object)"graph", (Object)graph);
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new DatabaseException(t);
            }
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }

    private static final class ValidationCompilationRequest
    extends CompileSCLMonitorRequest {
        private final String expression;

        private ValidationCompilationRequest(ReadGraph graph, Variable context, String expression) throws DatabaseException {
            super(graph, context);
            this.expression = expression;
        }

        @Override
        protected String getExpressionText(ReadGraph graph) throws DatabaseException {
            return this.expression;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 37 * this.expression.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && ((ValidationCompilationRequest)((Object)obj)).expression.equals(this.expression);
        }
    }
}

