/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableReference;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.subscription.AddSubscriptionItems;
import org.simantics.modeling.subscription.NewSubscription;
import org.simantics.modeling.subscription.NewSubscriptionItem;
import org.simantics.modeling.subscription.SubscriptionItemLabel;

public class SCLSubscription {
    public static Resource addSubscriptionFolder(WriteGraph graph, Resource model, String name) throws DatabaseException {
        NewSubscription folder = new NewSubscription(model, name);
        folder.perform(graph);
        return folder.subscription;
    }

    public static Resource addSubscriptionItems(WriteGraph graph, Resource subscriptionresource, Variable variable) throws DatabaseException {
        ArrayList<VariableReference> references = (ArrayList<VariableReference>)variable.getPossiblePropertyValue((ReadGraph)graph, "variableReferences");
        if (references == null) {
            VariableReference ref = new VariableReference(variable.getRVI((ReadGraph)graph), variable.getDatatype((ReadGraph)graph), null);
            references = new ArrayList<VariableReference>(1);
            references.add(ref);
        }
        AddSubscriptionItems subitems = new AddSubscriptionItems(subscriptionresource, (Collection<VariableReference>)references);
        subitems.perform(graph);
        return subitems.result.get(subitems.result.size() - 1);
    }

    public static Resource newSubscriptionItem(WriteGraph graph, Resource subscriptionresource, Variable variable, double interval, double deadband, double gain, double bias, String unit, String label) throws DatabaseException {
        return SCLSubscription.newSubscriptionItem(graph, subscriptionresource, null, variable, interval, deadband, gain, bias, unit, label);
    }

    public static Resource newSubscriptionItem(WriteGraph graph, Resource subscriptionresource, String itemId, Variable variable, double interval, double deadband, double gain, double bias, String unit, String label) throws DatabaseException {
        NewSubscriptionItem ns = new NewSubscriptionItem(subscriptionresource, interval, deadband, gain, bias, unit, label, itemId, variable.getRVI((ReadGraph)graph), variable.getDatatype((ReadGraph)graph));
        ns.perform(graph);
        return ns.subscriptionItem;
    }

    public static Resource defaultSubscriptionFolder(ReadGraph graph, Resource model) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MR = ModelingResources.getInstance((ReadGraph)graph);
        Collection childrens = graph.getObjects(model, l0.ConsistsOf);
        Resource folder = null;
        for (Resource children : childrens) {
            String label;
            if (!graph.isInstanceOf(children, MR.Subscription) || !(label = (String)graph.getRelatedValue2(folder = children, l0.HasLabel)).equals("Default")) continue;
            return folder;
        }
        return folder;
    }

    public static String getLabel(ReadGraph graph, Resource subscription) throws DatabaseException {
        return SubscriptionItemLabel.resolveLabel(graph, subscription, true);
    }
}

