/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.mapping;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.mapping.constraint.instructions.TypedBracketInstruction;
import org.simantics.modeling.services.ComponentNamingUtil;
import org.simantics.modeling.services.NamingException;
import org.simantics.project.IProject;

public class NamingCreationInstruction
extends TypedBracketInstruction.CreationInstruction {
    IProject project;
    int configurationRoot;
    int lComponentType;
    int lConfiguration;

    public NamingCreationInstruction(IProject project, int configurationRoot, int variableId, int componentType, int configuration) {
        super(variableId);
        this.project = project;
        this.configurationRoot = configurationRoot;
        this.lComponentType = componentType;
        this.lConfiguration = configuration;
    }

    public Resource create(WriteGraph g, Object[] bindings) throws DatabaseException {
        Resource componentType = (Resource)bindings[this.lComponentType];
        Resource configuration = (Resource)bindings[this.lConfiguration];
        try {
            CommonDBUtils.selectClusterSet((WriteGraph)g, (Resource)configuration);
            String proposition = ComponentNamingUtil.findFreshInstanceName((ReadGraph)g, this.project, (Resource)bindings[this.configurationRoot], configuration, componentType);
            Layer0 b = Layer0.getInstance((ReadGraph)g);
            Resource result = GraphUtils.create((WriteGraph)g, (Object[])new Object[]{b.HasName, proposition});
            Layer0Utils.claimNewIdentifier((WriteGraph)g, (Resource)result, (boolean)true);
            return result;
        }
        catch (NamingException e1) {
            throw new DatabaseException((Throwable)e1);
        }
    }

    public void mapVariables(TIntIntHashMap map) {
        super.mapVariables(map);
        this.lComponentType = map.get(this.lComponentType);
        this.lConfiguration = map.get(this.lConfiguration);
        this.configurationRoot = map.get(this.configurationRoot);
    }

    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        reads.add(this.lComponentType);
        reads.add(this.lConfiguration);
        reads.add(this.configurationRoot);
    }
}

