/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.web.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.simantics.g2d.diagram.participant.ElementTransferableProvider;

@JacksonStdImpl
public class ElementTransferableSerializer
extends StdSerializer<Object> {
    public static final ElementTransferableSerializer instance = new ElementTransferableSerializer();

    private ElementTransferableSerializer() {
        super(Object.class);
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value instanceof ElementTransferableProvider) {
            Transferable t = ((ElementTransferableProvider)value).create();
            try {
                DataFlavor flavor;
                Object o;
                if (t != null && (o = t.getTransferData(flavor = DataFlavor.getTextPlainUnicodeFlavor())) != null) {
                    ByteArrayInputStream is = (ByteArrayInputStream)o;
                    byte[] data = new byte[is.available()];
                    int read = 0;
                    while (is.available() > 0) {
                        read += is.read(data, read, data.length - read);
                    }
                    is.close();
                    String s = new String(data, flavor.getParameter("charset"));
                    s = s.replaceAll("\n", "");
                    gen.writeRawValue(s);
                    return;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {}
        }
        gen.writeNull();
    }
}

