/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.web.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.awt.BasicStroke;
import java.io.IOException;

public class BasicStrokeSerializer
extends StdSerializer<BasicStroke> {
    private static final long serialVersionUID = 8516702877563833518L;

    public BasicStrokeSerializer() {
        this(null);
    }

    public BasicStrokeSerializer(Class<BasicStroke> t) {
        super(t);
    }

    public void serializeWithType(BasicStroke value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }

    public void serialize(BasicStroke value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeNumberField("width", value.getLineWidth());
        float[] da = value.getDashArray();
        if (da != null) {
            jgen.writeArrayFieldStart("dash");
            int i = 0;
            while (i < da.length) {
                jgen.writeNumber(da[i]);
                ++i;
            }
            jgen.writeEndArray();
        }
    }
}

