/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.web;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import javax.imageio.ImageIO;
import org.eclipse.core.runtime.IAdaptable;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.DiagramTypeUtils;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.symbolcontribution.GroupProxySymbolItem;
import org.simantics.diagram.symbolcontribution.ISymbolProvider;
import org.simantics.diagram.symbolcontribution.IdentifiedObject;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.diagram.participant.DiagramParticipant;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.handler.StaticSymbol;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.utils.QualityHints;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Symbols {
    private static final Logger LOGGER = LoggerFactory.getLogger(Symbols.class);

    public static List<Tuple2> readSymbols(ReadGraph graph, Resource diagram) throws DatabaseException {
        ISymbolProvider provider = DiagramTypeUtils.readSymbolContributions((ReadGraph)graph, (Resource)diagram);
        ArrayList<Tuple2> symbolGroups = new ArrayList<Tuple2>();
        for (ISymbolGroup group : provider.getSymbolGroups()) {
            ArrayList<Tuple2> symbols = new ArrayList<Tuple2>();
            symbolGroups.add(new Tuple2((Object)group.getName(), symbols));
            ISymbolItem[] iSymbolItemArray = group.getItems();
            int n = iSymbolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource;
                Object id;
                ISymbolItem item = iSymbolItemArray[n2];
                if (item instanceof GroupProxySymbolItem) {
                    item = ((GroupProxySymbolItem)item).getSubject();
                }
                if (item instanceof IdentifiedObject && (id = ((IdentifiedObject)item).getId()) instanceof IAdaptable && (resource = (Resource)((IAdaptable)id).getAdapter(Resource.class)) != null) {
                    symbols.add(new Tuple2((Object)item.getName(), (Object)resource));
                }
                ++n2;
            }
        }
        return symbolGroups;
    }

    public static byte[] symbolToPNG(Resource symbol) throws DatabaseException, IOException {
        IDiagram diagram = Diagram.spawnNew((DiagramClass)DiagramClass.DEFAULT);
        IThreadWorkQueue thread = AWTThread.getThreadAccess();
        final CanvasContext ctx = new CanvasContext(thread);
        ctx.add((Object)new TransformUtil());
        ctx.add((Object)new DiagramParticipant());
        ctx.add((Object)new ElementPainter());
        IHintContext hintCtx = ctx.getDefaultHintContext();
        hintCtx.setHint(DiagramHints.KEY_DIAGRAM, (Object)diagram);
        ElementClass ec = (ElementClass)Simantics.getSession().syncRequest(DiagramRequests.getElementClass((Resource)symbol, (IHintObservable)diagram));
        StaticSymbol ss = (StaticSymbol)ec.getSingleItem(StaticSymbol.class);
        Image source = ss == null ? (Image)DefaultImages.UNKNOWN2.get() : ss.getImage();
        source.init(ctx.getCanvasNode());
        final Rectangle2D diagramRect = source.getBounds();
        final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        final Semaphore done = new Semaphore(0);
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        int width = 100;
                        int height = 100;
                        Rectangle2D.Double controlArea = new Rectangle2D.Double(0.0, 0.0, width, height);
                        ((TransformUtil)ctx.getSingleItem(TransformUtil.class)).fitArea((Rectangle2D)controlArea, diagramRect, MarginUtils.NO_MARGINS);
                        BufferedImage bi = new BufferedImage(width, height, 2);
                        Graphics2D g2 = bi.createGraphics();
                        QualityHints.HIGH_QUALITY_HINTS.setQuality(g2);
                        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                        g2.setTransform(new AffineTransform());
                        g2.setClip(new Rectangle2D.Double(0.0, 0.0, ((RectangularShape)controlArea).getWidth(), ((RectangularShape)controlArea).getHeight()));
                        g2.setRenderingHint((RenderingHints.Key)G2DRenderingHints.KEY_CONTROL_BOUNDS, new Rectangle2D.Double(0.0, 0.0, ((RectangularShape)controlArea).getWidth(), ((RectangularShape)controlArea).getHeight()));
                        ctx.getSceneGraph().render(g2);
                        try {
                            ImageIO.write((RenderedImage)bi, "PNG", outputStream);
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to write PNG file", (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to generate symbol image", (Throwable)e);
                        done.release();
                    }
                }
                finally {
                    done.release();
                }
            }
        });
        try {
            done.acquire();
        }
        catch (InterruptedException e) {
            LOGGER.error("Symbol rendering was interrupted", (Throwable)e);
        }
        return outputStream.toByteArray();
    }
}

