/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLink;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RoutePoint;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.content.ResourceTerminal;
import org.simantics.diagram.content.TerminalMap;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.elements.ElementTransforms;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.handler.CopyPasteHandler;
import org.simantics.diagram.participant.ConnectionBuilder;
import org.simantics.diagram.participant.ControlPoint;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.RemoveElement;
import org.simantics.diagram.synchronization.graph.TranslateElement;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IContentContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.connection.IConnectionAdvisor;
import org.simantics.g2d.connection.TerminalKeyOf;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.participant.ElementJSON;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.ZOrderHandler;
import org.simantics.g2d.diagram.participant.ZOrderListener;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.elementclass.BranchPoint;
import org.simantics.g2d.elementclass.RouteGraphConnectionClass;
import org.simantics.g2d.layers.ILayers;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.g2d.layers.LayersConfiguration;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.PageBorderParticipant;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.g2d.tooltip.TooltipParticipant;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.triggers.IActivation;
import org.simantics.layer0.utils.triggers.IActivationManager;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.sg.DiagramSceneGraphProvider;
import org.simantics.modeling.web.DirtyElementsTracker;
import org.simantics.modeling.web.JSONGenerator;
import org.simantics.modeling.web.NodeMapper;
import org.simantics.modeling.web.serializer.RouteGraphSerializer;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.G2DWebalizerHints;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.IG2DNodeVisitor;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.structural2.StructuralVariables;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.structural2.modelingRules.IConnectionPoint;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.Triple;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.threads.WorkerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneGraphWebalizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SceneGraphWebalizer.class);
    private WorkerThread thread = new WorkerThread("Web Diagram Painter");
    private CanvasContext ctx = new CanvasContext((IThreadWorkQueue)this.thread);
    private IActivation activation;
    private Function2<String, String, Boolean> listener;
    private Resource diagram;
    private ICanvasSceneGraphProvider provider;
    private ObjectMapper mapper = new NodeMapper();
    private Map<Long, IG2DNode> nodeMap = new HashMap<Long, IG2DNode>();
    private Map<Long, Map<Long, ObjectNode>> fullClientNodeState = new HashMap<Long, Map<Long, ObjectNode>>();
    private DirtyElementsTracker dirtyElementsTracker = new DirtyElementsTracker();
    private String border = null;
    private String clientBorder = null;
    private Map<Long, Integer> elementZMap = new HashMap<Long, Integer>();
    private boolean orderChanged = false;
    private boolean crossingChanged = false;
    private String crossingStyle = null;
    private Double crossingWidth = 0.0;
    private Color backgroundColor = null;
    private boolean backgroundColorChanged = true;
    private boolean defaultTransformations = true;
    private LayersConfiguration layersConfiguration = null;
    private boolean init = true;

    public SceneGraphWebalizer(Resource diagram, Function2<String, String, Boolean> listener) throws Exception {
        this(diagram, null, listener);
    }

    public SceneGraphWebalizer(final Resource diagram, Variable __context, Function2<String, String, Boolean> listener) throws Exception {
        this.diagram = diagram;
        this.listener = listener;
        this.thread.start();
        this.ctx.add((Object)this.dirtyElementsTracker);
        this.ctx.add((Object)new ElementJSONImpl());
        final ISessionContext sessionContext = Simantics.getSessionContext();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    if (SceneGraphWebalizer.this.ctx.isDisposed()) {
                        return;
                    }
                    Pair modelAndRVI = (Pair)sessionContext.getSession().syncRequest((Read)new UniqueRead<Pair<Resource, String>>(){

                        public Pair<Resource, String> perform(ReadGraph graph) throws DatabaseException {
                            Resource model = SceneGraphWebalizer.resolveModel(graph, diagram);
                            return new Pair((Object)model, (Object)SceneGraphWebalizer.resolveRVI(graph, model, diagram));
                        }
                    });
                    SceneGraphWebalizer.this.provider = DiagramNodeUtil.loadSceneGraphProviderForDiagram((ICanvasContext)SceneGraphWebalizer.this.ctx, (Resource)((Resource)modelAndRVI.first), (Resource)diagram, (String)((String)modelAndRVI.second), (LayersConfiguration)SceneGraphWebalizer.this.layersConfiguration);
                    final IDiagram d = (IDiagram)SceneGraphWebalizer.this.ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
                    ILayersEditor layersEditor = (ILayersEditor)d.getHint(DiagramHints.KEY_LAYERS);
                    if (layersEditor != null) {
                        layersEditor.addLayersListener(new ILayers.ILayersListener(){

                            public void changed() {
                                ThreadUtils.asyncExec((IThreadWorkQueue)(this).SceneGraphWebalizer.this.thread, (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        for (IElement element : d.getElements()) {
                                            element.setHint(Hints.KEY_DIRTY, (Object)Hints.VALUE_SG_DIRTY);
                                        }
                                        ((this).this).SceneGraphWebalizer.this.provider.getCanvasContext().getContentContext().setDirty();
                                    }
                                });
                            }
                        });
                    }
                    SceneGraphWebalizer.this.ctx.add((Object)new PageBorderParticipant(){

                        protected void updateNode(boolean markDirty) {
                            super.updateNode(markDirty);
                            SceneGraphWebalizer.this.runMutex(() -> {
                                NodeMapper mapper = new NodeMapper();
                                JSONGenerator jsonGenerator = new JSONGenerator(mapper, null);
                                (this).SceneGraphWebalizer.this.border = jsonGenerator.asSVG((IG2DNode)this.node, false);
                                (this).SceneGraphWebalizer.this.provider.getCanvasContext().getContentContext().setDirty();
                            });
                        }
                    });
                    ZOrderHandler zoh = (ZOrderHandler)SceneGraphWebalizer.this.ctx.getAtMostOneItemOfClass(ZOrderHandler.class);
                    zoh.addOrderListener(new ZOrderListener(){

                        public void orderChanged(IDiagram diagram) {
                            SceneGraphWebalizer.this.runMutex(() -> {
                                (this).SceneGraphWebalizer.this.orderChanged = true;
                                (this).SceneGraphWebalizer.this.provider.getCanvasContext().getContentContext().setDirty();
                            });
                        }
                    });
                    Simantics.getSession().async((ReadInterface)new UnaryRead<Resource, Pair<Double, String>>(diagram){

                        public Pair<Double, String> perform(ReadGraph graph) throws DatabaseException {
                            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            Double width = (Double)graph.getPossibleRelatedValue(diagram, DIA.ConnectionCrossingStyle_Width);
                            Resource typeRes = graph.getPossibleObject(diagram, DIA.ConnectionCrossingStyle_HasType);
                            String style = (String)graph.getPossibleRelatedValue(typeRes, L0.HasName);
                            return new Pair((Object)width, (Object)style);
                        }
                    }, (Listener)new Listener<Pair<Double, String>>(){

                        public void execute(Pair<Double, String> result) {
                            SceneGraphWebalizer.this.runMutex(() -> {
                                (this).SceneGraphWebalizer.this.crossingChanged = true;
                                (this).SceneGraphWebalizer.this.crossingWidth = (Double)pair.first;
                                (this).SceneGraphWebalizer.this.crossingStyle = (String)pair.second;
                                (this).SceneGraphWebalizer.this.provider.getCanvasContext().getContentContext().setDirty();
                            });
                        }

                        public void exception(Throwable t) {
                        }

                        public boolean isDisposed() {
                            if ((this).SceneGraphWebalizer.this.ctx == null) {
                                return true;
                            }
                            return (this).SceneGraphWebalizer.this.ctx.isDisposed();
                        }
                    });
                    IHintContext h = SceneGraphWebalizer.this.ctx.getDefaultHintContext();
                    SceneGraphWebalizer.this.backgroundColor = (Color)h.getHint(Hints.KEY_BACKGROUND_COLOR);
                    h.addKeyHintListener(Hints.KEY_BACKGROUND_COLOR, new IHintListener(){

                        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                            SceneGraphWebalizer.this.runMutex(() -> {
                                (this).SceneGraphWebalizer.this.backgroundColor = (Color)newValue;
                                (this).SceneGraphWebalizer.this.backgroundColorChanged = true;
                                (this).SceneGraphWebalizer.this.provider.getCanvasContext().getContentContext().setDirty();
                            });
                        }

                        public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
                            SceneGraphWebalizer.this.runMutex(() -> {
                                (this).SceneGraphWebalizer.this.backgroundColor = null;
                                (this).SceneGraphWebalizer.this.backgroundColorChanged = true;
                                (this).SceneGraphWebalizer.this.provider.getCanvasContext().getContentContext().setDirty();
                            });
                        }
                    });
                    IActivationManager activationManager = (IActivationManager)sessionContext.getSession().peekService(IActivationManager.class);
                    if (activationManager != null) {
                        SceneGraphWebalizer.this.activation = activationManager.activate(diagram);
                    }
                    final Runnable repaint = () -> {
                        if (SceneGraphWebalizer.this.isDisposed()) {
                            return;
                        }
                        Pair<Set<IElement>, Set<Long>> result = SceneGraphWebalizer.this.dirtyElementsTracker.fetchChanges();
                        Set dirtyElements = (Set)result.first;
                        Set removedElements = (Set)result.second;
                        if (dirtyElements.size() > 0 || removedElements.size() > 0 || !Objects.equals(SceneGraphWebalizer.this.border, SceneGraphWebalizer.this.clientBorder) || SceneGraphWebalizer.this.orderChanged || SceneGraphWebalizer.this.crossingChanged || SceneGraphWebalizer.this.backgroundColorChanged) {
                            SceneGraphWebalizer.this.onRepaint(dirtyElements, removedElements);
                        }
                    };
                    SceneGraphWebalizer.this.runMutex(repaint);
                    SceneGraphWebalizer.this.provider.getCanvasContext().getContentContext().addPaintableContextListener(new IContentContext.IContentListener(){

                        public void onDirty(IContentContext sender) {
                            SceneGraphWebalizer.this.runMutex(repaint);
                        }
                    });
                }
                catch (InterruptedException | DatabaseException e) {
                    LOGGER.error("Failed to load diagram.", e);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public void resetClientState() {
        this.runMutex(() -> {
            this.fullClientNodeState.clear();
            this.nodeMap.clear();
            this.clientBorder = null;
            this.dirtyElementsTracker.reset();
            this.provider.getCanvasContext().getContentContext().setDirty();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRepaint(Set<IElement> dirtyElements, Set<Long> removedElements) {
        ObjectNode root = new ObjectNode(JsonNodeFactory.instance);
        ICanvasContext ctx = this.provider.getCanvasContext();
        if (ctx == null) {
            return;
        }
        IDiagram diagram = (IDiagram)ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        if (diagram == null) {
            return;
        }
        ILayers layers = (ILayers)diagram.getHint(DiagramHints.KEY_LAYERS);
        JSONGenerator jsonGenerator = new JSONGenerator(this.mapper, diagram);
        assert (ctx.getSceneGraph() != null);
        assert ((G2DSceneGraph)ctx.getSceneGraph().getRootNode() != null);
        ((G2DSceneGraph)ctx.getSceneGraph().getRootNode()).performCleanup();
        if (!Objects.equals(this.border, this.clientBorder)) {
            root.put("border", this.border);
            this.clientBorder = this.border;
        }
        if (this.orderChanged) {
            ArrayNode reorder = root.putArray("reorder");
            for (IElement element : diagram.getElements()) {
                IG2DNode node = (IG2DNode)element.getHint(ElementHints.KEY_SG_NODE);
                Resource resource = (Resource)ElementUtils.getObject((IElement)element);
                Integer currentZ = node.getZIndex();
                long elementId = resource.getResourceId();
                Integer prevZ = this.elementZMap.put(elementId, currentZ);
                if (Objects.equals(prevZ, currentZ)) continue;
                ObjectNode elem = reorder.addObject();
                IG2DNode n = (IG2DNode)element.getHint(ElementHints.KEY_SG_NODE);
                elem.put("id", elementId);
                elem.put("z", n.getZIndex());
            }
            this.orderChanged = false;
        }
        if (this.crossingChanged) {
            ObjectNode crossings = root.putObject("crossing");
            crossings.put("width", this.crossingWidth);
            crossings.put("style", this.crossingStyle);
            this.crossingChanged = false;
        }
        if (this.backgroundColorChanged) {
            ObjectNode background = root.putObject("background");
            background.put("color", this.backgroundColor != null ? String.format("#%02x%02x%02x", this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue()) : "#ffffff");
            this.backgroundColorChanged = false;
        }
        ArrayNode elements = root.putArray("elements");
        final ArrayList<Triple> judgeTasks = new ArrayList<Triple>();
        for (IElement dirtyElement : dirtyElements) {
            Object hints;
            SingleElementNode sne;
            Resource resource = (Resource)ElementUtils.getObject((IElement)dirtyElement);
            long elementId = 0L;
            if (resource == null || removedElements.contains(elementId = resource.getResourceId())) continue;
            IG2DNode node = (IG2DNode)dirtyElement.getHint(ElementHints.KEY_SG_NODE);
            if (node instanceof SingleElementNode) {
                boolean notLayersIgnored;
                SingleElementNode sne2 = (SingleElementNode)node;
                boolean bl = layers != null ? !layers.getIgnoreVisibilitySettings() : (notLayersIgnored = false);
                if (notLayersIgnored && (sne2.isHidden() || !sne2.isVisible())) {
                    if (!this.fullClientNodeState.containsKey(elementId)) continue;
                    removedElements.add(elementId);
                    continue;
                }
            }
            ObjectNode element = elements.addObject();
            Map<Long, ObjectNode> clientNodeState = this.fullClientNodeState.get(elementId);
            if (clientNodeState == null) {
                clientNodeState = new HashMap<Long, ObjectNode>();
                this.fullClientNodeState.put(elementId, clientNodeState);
            }
            boolean isConnection = node instanceof ConnectionNode;
            boolean selectable = true;
            if (node instanceof SingleElementNode && (sne = (SingleElementNode)node).getNodeCount() == 1) {
                for (IG2DNode child : sne.getNodes()) {
                    if (!(child instanceof IAdaptable) || (hints = (G2DWebalizerHints)((IAdaptable)child).getAdapter(G2DWebalizerHints.class)) == null) continue;
                    selectable = hints.isSelectable();
                }
            }
            element.put("id", elementId);
            element.put("root", node.getId());
            element.put("perPixel", isConnection);
            element.put("selectable", selectable);
            element.put("z", node.getZIndex());
            element.put("draggable", !isConnection);
            ArrayNode terminalsNode = element.putArray("terminals");
            ArrayList terminals = new ArrayList();
            ElementUtils.getTerminals((IElement)dirtyElement, terminals, (boolean)false);
            hints = terminals.iterator();
            while (hints.hasNext()) {
                Topology.Terminal terminal = (Topology.Terminal)hints.next();
                long terminalId = ((ResourceTerminal)terminal).getResource().getResourceId();
                Shape shape = TerminalUtil.getTerminalShape((IElement)dirtyElement, (Topology.Terminal)terminal);
                AffineTransform transform = TerminalUtil.getTerminalPosOnDiagram((IElement)dirtyElement, (Topology.Terminal)terminal);
                Path2D.Double shapePath = new Path2D.Double(shape, transform);
                Rectangle2D bbox = shapePath.getBounds2D();
                ObjectNode terminalNode = terminalsNode.addObject();
                terminalNode.put("id", terminalId);
                terminalNode.set("shape", this.mapper.valueToTree((Object)shapePath));
                ObjectNode bboxNode = terminalNode.putObject("bbox");
                bboxNode.put("x", bbox.getX());
                bboxNode.put("y", bbox.getY());
                bboxNode.put("width", bbox.getWidth());
                bboxNode.put("height", bbox.getHeight());
                judgeTasks.add(new Triple((Object)dirtyElement, (Object)terminal, (Object)terminalNode));
            }
            ArrayNode nodes = element.putArray("nodes");
            ArrayNode removed = element.putArray("removedNodes");
            jsonGenerator.getNodes().clear();
            node.accept((IG2DNodeVisitor)jsonGenerator);
            Map<Long, IG2DNode> terminalId = this.nodeMap;
            synchronized (terminalId) {
                node.accept(new IG2DNodeVisitor(){

                    public void leave(IG2DNode node) {
                    }

                    public void enter(IG2DNode node) {
                        SceneGraphWebalizer.this.nodeMap.put(node.getId(), node);
                    }
                });
            }
            HashSet<Long> removedNodes = new HashSet<Long>();
            removedNodes.addAll(clientNodeState.keySet());
            for (ObjectNode currentNode : jsonGenerator.getNodes()) {
                Long id;
                ObjectNode oldNode;
                if (!currentNode.equals((Object)(oldNode = clientNodeState.get(id = Long.valueOf(currentNode.get("id").asLong()))))) {
                    nodes.add((JsonNode)currentNode);
                    clientNodeState.put(id, currentNode);
                }
                removedNodes.remove(id);
            }
            Map<Long, IG2DNode> map = this.nodeMap;
            synchronized (map) {
                for (Long id : removedNodes) {
                    removed.add(id);
                    clientNodeState.remove(id);
                    this.elementZMap.remove(id);
                    this.nodeMap.remove(id);
                }
            }
        }
        try {
            Simantics.sync((ReadInterface)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    IDiagram diagram = (IDiagram)SceneGraphWebalizer.this.provider.getCanvasContext().getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
                    IModelingRules modelingRules = (IModelingRules)diagram.getHint(DiagramModelHints.KEY_MODELING_RULES);
                    IConnectionAdvisor connectionAdvisor = (IConnectionAdvisor)diagram.getHint(DiagramHints.CONNECTION_ADVISOR);
                    if (connectionAdvisor != null) {
                        for (Triple judgeTask : judgeTasks) {
                            IElement element = (IElement)judgeTask.first;
                            Topology.Terminal terminal = (Topology.Terminal)judgeTask.second;
                            ObjectNode terminalNode = (ObjectNode)judgeTask.third;
                            terminalNode.put("canBegin", connectionAdvisor.canBeginConnection((Object)graph, element, terminal));
                        }
                    } else {
                        for (Triple judgeTask : judgeTasks) {
                            IElement element = (IElement)judgeTask.first;
                            Topology.Terminal terminal = (Topology.Terminal)judgeTask.second;
                            ObjectNode terminalNode = (ObjectNode)judgeTask.third;
                            TerminalUtil.TerminalInfo ti = new TerminalUtil.TerminalInfo();
                            ti.e = element;
                            ti.t = terminal;
                            ConnectionJudgement judgement = modelingRules.judgeConnection(graph, Arrays.asList(ConnectionUtil.toConnectionPoint((ReadGraph)graph, (TerminalUtil.TerminalInfo)ti)));
                            terminalNode.put("canBegin", judgement != null && judgement != ConnectionJudgement.ILLEGAL);
                        }
                    }
                }
            });
        }
        catch (DatabaseException e1) {
            LOGGER.error("Failed to judge connections.", (Throwable)e1);
        }
        ArrayNode removed = root.putArray("removed");
        Iterator<Object> iterator = removedElements.iterator();
        while (iterator.hasNext()) {
            long elementId = iterator.next();
            removed.add(elementId);
            this.fullClientNodeState.remove(elementId);
        }
        ArrayNode newDefs = root.putArray("defs");
        for (Map.Entry entry : jsonGenerator.flushNewDefs().entrySet()) {
            ObjectNode newDef = newDefs.addObject();
            newDef.put("id", (String)entry.getKey());
            newDef.put("def", (String)entry.getValue());
        }
        try {
            String string = this.mapper.writeValueAsString((Object)root);
            if (!((Boolean)this.listener.apply((Object)(this.init ? "init" : "update"), (Object)string)).booleanValue()) {
                this.cleanUp();
            }
            this.init = false;
        }
        catch (JsonProcessingException jsonProcessingException) {
            LOGGER.error("Failed to write JSON string.", (Throwable)jsonProcessingException);
            this.cleanUp();
        }
    }

    public Resource elementIdToElement(ReadGraph graph, String id) throws DatabaseException {
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        return ss.getResource(Long.parseLong(id));
    }

    public Resource terminalIdToElement(ReadGraph graph, String id) throws DatabaseException {
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        return ss.getResource(Long.parseLong(id));
    }

    public Resource connectIdToConnection(ReadGraph graph, String id) throws DatabaseException {
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        return ss.getResource(Long.parseLong(id));
    }

    private Resource[] elementIdsToElementArray(ReadGraph graph, List<String> ids) throws DatabaseException {
        ArrayList<Resource> elements = new ArrayList<Resource>();
        for (String id : ids) {
            Resource res = this.elementIdToElement(graph, id);
            if (res == null) continue;
            elements.add(res);
        }
        return elements.toArray(new Resource[elements.size()]);
    }

    public void translateElements(WriteGraph graph, List<String> ids, double dx, double dy) throws DatabaseException {
        if (!this.defaultTransformations) {
            return;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ConnectionUtil cu = new ConnectionUtil(graph);
        graph.markUndoPoint();
        for (String id : ids) {
            Resource element = this.elementIdToElement((ReadGraph)graph, id);
            if (graph.isInstanceOf(element, DIA.RouteGraphConnection)) {
                cu.translateRouteNodes(element, dx, dy);
                continue;
            }
            TranslateElement.offset((Resource)element, (double)dx, (double)dy).perform(graph);
        }
    }

    public void transformElements(WriteGraph graph, List<Tuple2> transformations) throws DatabaseException {
        if (!this.defaultTransformations) {
            return;
        }
        graph.markUndoPoint();
        for (Tuple2 tuple : transformations) {
            String id = (String)tuple.c0;
            List t = (List)tuple.c1;
            Resource element = this.elementIdToElement((ReadGraph)graph, id);
            AffineTransform at = DiagramGraphUtil.getTransform((ReadGraph)graph, (Resource)element);
            AffineTransform at2 = new AffineTransform((Double)t.get(0), (Double)t.get(1), (Double)t.get(2), (Double)t.get(3), (Double)t.get(4), (Double)t.get(5));
            DiagramGraphUtil.changeTransform((WriteGraph)graph, (Resource)element, (AffineTransform)at2);
            System.out.println(at.toString());
            System.out.println(t.toString());
        }
    }

    public void rotateElements(WriteGraph graph, List<String> ids, boolean clockwise) throws DatabaseException {
        if (!this.defaultTransformations) {
            return;
        }
        IDiagram diagram = (IDiagram)this.ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        if (diagram != null) {
            ElementTransforms.rotate((IDiagram)diagram, (Resource[])this.elementIdsToElementArray((ReadGraph)graph, ids), (boolean)clockwise);
        }
    }

    public void flipElements(WriteGraph graph, List<String> ids, boolean horizontal) throws DatabaseException {
        if (!this.defaultTransformations) {
            return;
        }
        IDiagram diagram = (IDiagram)this.ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        if (diagram != null) {
            ElementTransforms.flip((IDiagram)diagram, (Resource[])this.elementIdsToElementArray((ReadGraph)graph, ids), (!horizontal ? 1 : 0) != 0);
        }
    }

    private Collection<IElement> elementIdsToIElements(final CanvasContext ctx, final Collection<String> ids) throws DatabaseException {
        return (Collection)Simantics.sync((ReadInterface)new UnaryRead<Collection<String>, Collection<IElement>>(ids){

            public Collection<IElement> perform(ReadGraph graph) throws DatabaseException {
                ArrayList<IElement> result = new ArrayList<IElement>();
                for (String elementId : ids) {
                    Resource er = SceneGraphWebalizer.this.elementIdToElement(graph, elementId);
                    IElement e = DiagramNodeUtil.findElement((ICanvasContext)ctx, (Resource)er);
                    result.add(e);
                }
                return result;
            }
        });
    }

    private void handleZCommand(final List<String> ids, final Command command) {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

            @Override
            public void run() {
                ZOrderHandler zoh = (ZOrderHandler)SceneGraphWebalizer.this.ctx.getAtMostOneItemOfClass(ZOrderHandler.class);
                try {
                    Collection<IElement> elements = SceneGraphWebalizer.this.elementIdsToIElements(SceneGraphWebalizer.this.ctx, ids);
                    Selection selection = (Selection)SceneGraphWebalizer.this.ctx.getAtMostOneItemOfClass(Selection.class);
                    selection.setSelection(0, elements);
                    zoh.handleCommand(new CommandEvent(null, 0L, command));
                    selection.setSelection(0, Collections.emptySet());
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to change the Z order.", (Throwable)e);
                }
            }
        });
    }

    public void moveElementsUp(List<String> ids) {
        this.handleZCommand(ids, Commands.BRING_UP);
    }

    public void moveElementsDown(List<String> ids) {
        this.handleZCommand(ids, Commands.SEND_DOWN);
    }

    public void moveElementsToTop(List<String> ids) {
        this.handleZCommand(ids, Commands.BRING_TO_TOP);
    }

    public void moveElementsToBottom(List<String> ids) {
        this.handleZCommand(ids, Commands.SEND_TO_BOTTOM);
    }

    public void connectFrom(ReadGraph graph, String elementId, String terminalId) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        IDiagram idiagram = (IDiagram)this.ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        IModelingRules modelingRules = (IModelingRules)idiagram.getHint(DiagramModelHints.KEY_MODELING_RULES);
        IConnectionAdvisor connectionAdvisor = (IConnectionAdvisor)idiagram.getHint(DiagramHints.CONNECTION_ADVISOR);
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode result = mapper.createObjectNode();
        result.put("source", Long.parseLong(terminalId));
        ArrayNode targets = result.putArray("targets");
        Resource element = this.elementIdToElement(graph, elementId);
        IElement e = DiagramNodeUtil.findElement((ICanvasContext)this.ctx, (Resource)element);
        Resource terminal = this.terminalIdToElement(graph, terminalId);
        ResourceTerminal t = new ResourceTerminal(terminal);
        Resource cp = DiagramGraphUtil.getConnectionPointOfTerminal((ReadGraph)graph, (Resource)terminal);
        CPTerminal cpt = new CPTerminal(element, cp);
        for (Resource targetElement : OrderedSetUtils.toList((ReadGraph)graph, (Resource)this.diagram)) {
            if (graph.isInstanceOf(targetElement, DIA.Connection) || targetElement.equals(element)) continue;
            IElement e2 = DiagramNodeUtil.findElement((ICanvasContext)this.ctx, (Resource)targetElement);
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Resource component = graph.getPossibleObject(targetElement, MOD.ElementToComponent);
            if (component == null) continue;
            TerminalMap terminals = DiagramGraphUtil.getElementTerminals((ReadGraph)graph, (Resource)targetElement);
            for (Resource targetTerminal : terminals.getTerminals()) {
                ResourceTerminal t2 = new ResourceTerminal(targetTerminal);
                Resource targetCP = DiagramGraphUtil.getConnectionPointOfTerminal((ReadGraph)graph, (Resource)targetTerminal);
                CPTerminal targetCPT = new CPTerminal(targetElement, targetCP);
                ConnectionJudgement judgement = null;
                judgement = connectionAdvisor != null ? (ConnectionJudgement)connectionAdvisor.canBeConnected((Object)graph, e, (Topology.Terminal)t, e2, (Topology.Terminal)t2) : modelingRules.judgeConnection(graph, Arrays.asList(cpt, targetCPT));
                if (judgement == null || judgement == ConnectionJudgement.ILLEGAL) continue;
                Long targetTerminalId = targetTerminal.getResourceId();
                ObjectNode target = targets.addObject();
                target.put("e", targetElement.getResourceId());
                target.put("t", targetTerminalId);
            }
        }
        try {
            this.listener.apply((Object)"mayConnectTo", (Object)mapper.writeValueAsString((Object)result));
        }
        catch (JsonProcessingException ex) {
            LOGGER.error("Failed to create Json string.", (Throwable)ex);
        }
    }

    public void connectFromFlag(WriteGraph graph, double flagX, double flagY, String elementId, String terminalId) throws DatabaseException {
        this.connectNewFlag(flagX, flagY, elementId, terminalId, true);
    }

    public void connectToFlag(double flagX, double flagY, String elementId, String terminalId) throws DatabaseException {
        this.connectNewFlag(flagX, flagY, elementId, terminalId, false);
    }

    public void connectNewFlag(final double flagX, final double flagY, final String elementId, final String terminalId, final boolean startFromFlag) {
        IDiagram diagram = (IDiagram)this.ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        Boolean flags = (Boolean)diagram.getHint(DiagramHints.KEY_USE_CONNECTION_FLAGS);
        if (flags != null && !flags.booleanValue()) {
            return;
        }
        ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Simantics.sync((WriteInterface)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            IDiagram diagram = (IDiagram)(this).SceneGraphWebalizer.this.ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
                            ConnectionBuilder builder = new ConnectionBuilder(diagram);
                            IModelingRules modelingRules = (IModelingRules)diagram.getHint(DiagramModelHints.KEY_MODELING_RULES);
                            IConnectionAdvisor cfr_ignored_0 = (IConnectionAdvisor)diagram.getHint(DiagramHints.CONNECTION_ADVISOR);
                            if (modelingRules == null) {
                                return;
                            }
                            Resource er = SceneGraphWebalizer.this.elementIdToElement((ReadGraph)graph, elementId);
                            IElement e = DiagramNodeUtil.findElement((ICanvasContext)(this).SceneGraphWebalizer.this.ctx, (Resource)er);
                            ResourceTerminal t = new ResourceTerminal(SceneGraphWebalizer.this.terminalIdToElement((ReadGraph)graph, terminalId));
                            TerminalUtil.TerminalInfo ti = new TerminalUtil.TerminalInfo();
                            ti.e = e;
                            ti.t = t;
                            ArrayList<IConnectionPoint> pts = new ArrayList<IConnectionPoint>();
                            pts.add(ConnectionUtil.toConnectionPoint((ReadGraph)graph, (TerminalUtil.TerminalInfo)ti));
                            ConnectionJudgement judgement = modelingRules.judgeConnection((ReadGraph)graph, pts);
                            if (judgement != null && judgement != ConnectionJudgement.ILLEGAL) {
                                LinkedList<ControlPoint> cps = new LinkedList<ControlPoint>();
                                cps.add(new ControlPoint((Point2D)new Point2D.Double(flagX, flagY), BranchPoint.Direction.Any));
                                if (startFromFlag) {
                                    builder.create(graph, judgement, cps, null, ti);
                                } else {
                                    builder.create(graph, judgement, cps, ti, null);
                                }
                            }
                        }
                    });
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to create connection.", (Throwable)e);
                }
            }
        });
    }

    public void connect(final String elementId1, final String terminalId1, final String elementId2, final String terminalId2) throws DatabaseException {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Simantics.sync((WriteInterface)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            IDiagram diagram = (IDiagram)(this).SceneGraphWebalizer.this.ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
                            ConnectionBuilder builder = new ConnectionBuilder(diagram);
                            IModelingRules modelingRules = (IModelingRules)diagram.getHint(DiagramModelHints.KEY_MODELING_RULES);
                            Resource er1 = SceneGraphWebalizer.this.elementIdToElement((ReadGraph)graph, elementId1);
                            Resource er2 = SceneGraphWebalizer.this.elementIdToElement((ReadGraph)graph, elementId2);
                            TerminalUtil.TerminalInfo ti1 = new TerminalUtil.TerminalInfo();
                            ti1.e = DiagramNodeUtil.findElement((ICanvasContext)(this).SceneGraphWebalizer.this.ctx, (Resource)er1);
                            ti1.t = new ResourceTerminal(SceneGraphWebalizer.this.terminalIdToElement((ReadGraph)graph, terminalId1));
                            TerminalUtil.TerminalInfo ti2 = new TerminalUtil.TerminalInfo();
                            ti2.e = DiagramNodeUtil.findElement((ICanvasContext)(this).SceneGraphWebalizer.this.ctx, (Resource)er2);
                            ti2.t = new ResourceTerminal(SceneGraphWebalizer.this.terminalIdToElement((ReadGraph)graph, terminalId2));
                            ArrayList<IConnectionPoint> pts = new ArrayList<IConnectionPoint>();
                            pts.add(ConnectionUtil.toConnectionPoint((ReadGraph)graph, (TerminalUtil.TerminalInfo)ti1));
                            pts.add(ConnectionUtil.toConnectionPoint((ReadGraph)graph, (TerminalUtil.TerminalInfo)ti2));
                            ConnectionJudgement judgement = modelingRules.judgeConnection((ReadGraph)graph, pts);
                            if (judgement != null && judgement != ConnectionJudgement.ILLEGAL) {
                                builder.create(graph, judgement, new LinkedList(), ti1, ti2);
                            }
                        }
                    });
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to create connection.", (Throwable)e);
                }
            }
        });
    }

    public void modifyRouteGraph(final String nodeId, final String partId, final double x, final double y) throws DatabaseException {
        ThreadUtils.syncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IG2DNode node;
                Map<Long, IG2DNode> map = SceneGraphWebalizer.this.nodeMap;
                synchronized (map) {
                    node = SceneGraphWebalizer.this.nodeMap.get(Long.parseLong(nodeId));
                }
                if (node instanceof RouteGraphNode) {
                    RouteGraphNode rgn = (RouteGraphNode)node;
                    RouteGraph before = rgn.getRouteGraph();
                    RouteGraph after = before.copy();
                    boolean changed = false;
                    block3: for (RouteLine line : after.getAllLines()) {
                        String id = RouteGraphSerializer.getRouteNodeId((RouteNode)line);
                        if (partId.equals(id)) {
                            after.setLocation(line, x, y);
                            changed = true;
                            break;
                        }
                        for (RoutePoint point : line.getPoints()) {
                            if (!partId.equals(RouteGraphSerializer.getRoutePointId(point))) continue;
                            if (point instanceof RouteTerminal) continue block3;
                            if (!(point instanceof RouteLink)) continue;
                            after.setLocation(((RouteLink)point).getA(), x, y);
                            after.setLocation(((RouteLink)point).getB(), x, y);
                            changed = true;
                            continue block3;
                        }
                    }
                    if (!changed && after.getAllLines().size() == 1) {
                        RouteLine line;
                        line = (RouteLine)after.getAllLines().iterator().next();
                        after.setLocation(line, x, y);
                    }
                    rgn.setRouteGraphAndFireChanges(before, after);
                }
            }
        });
    }

    public void deleteRouteGraphPart(final String nodeId, final String partId) throws DatabaseException {
        ThreadUtils.syncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IG2DNode node;
                Map<Long, IG2DNode> map = SceneGraphWebalizer.this.nodeMap;
                synchronized (map) {
                    node = SceneGraphWebalizer.this.nodeMap.get(Long.parseLong(nodeId));
                }
                if (node instanceof RouteGraphNode) {
                    RouteGraphNode rgn = (RouteGraphNode)node;
                    RouteGraph rg = rgn.getRouteGraph();
                    for (RouteLine line : rg.getAllLines()) {
                        if (partId.equals(RouteGraphSerializer.getRouteNodeId((RouteNode)line))) {
                            RouteGraph before = rg.copy();
                            rg.merge(line);
                            rgn.setRouteGraphAndFireChanges(before, rg);
                            break;
                        }
                        for (RoutePoint point : line.getPoints()) {
                            if (!(point instanceof RouteLink) || !partId.equals(RouteGraphSerializer.getRoutePointId(point))) continue;
                            RouteGraph before = rg.copy();
                            rg.deleteCorner((RouteLink)point);
                            rgn.setRouteGraphAndFireChanges(before, rg);
                        }
                    }
                }
            }
        });
    }

    public void clearRouteGraph(final String nodeId, String partId) throws DatabaseException {
        ThreadUtils.syncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IG2DNode node;
                Map<Long, IG2DNode> map = SceneGraphWebalizer.this.nodeMap;
                synchronized (map) {
                    node = SceneGraphWebalizer.this.nodeMap.get(Long.parseLong(nodeId));
                }
                if (node instanceof RouteGraphNode) {
                    RouteGraphNode rgn = (RouteGraphNode)node;
                    RouteGraph rg = rgn.getRouteGraph();
                    boolean changed = false;
                    RouteGraph before = rg.copy();
                    for (RouteLine line : rg.getAllLines()) {
                        rg.merge(line);
                        changed = true;
                    }
                    if (changed) {
                        rgn.setRouteGraphAndFireChanges(before, rg);
                    }
                }
            }
        });
    }

    public void splitRouteGraphPart(final String nodeId, final String partId, final double position) throws DatabaseException {
        ThreadUtils.syncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IG2DNode node;
                Map<Long, IG2DNode> map = SceneGraphWebalizer.this.nodeMap;
                synchronized (map) {
                    node = SceneGraphWebalizer.this.nodeMap.get(Long.parseLong(nodeId));
                }
                if (node instanceof RouteGraphNode) {
                    RouteGraphNode rgn = (RouteGraphNode)node;
                    RouteGraph rg = rgn.getRouteGraph();
                    for (RouteLine line : rg.getAllLines()) {
                        if (!partId.equals(RouteGraphSerializer.getRouteNodeId((RouteNode)line))) continue;
                        if (!(line instanceof RouteLine)) break;
                        RouteGraph before = rg.copy();
                        rg.split(line, position);
                        rgn.setRouteGraphAndFireChanges(before, rg);
                        break;
                    }
                }
            }
        });
    }

    public Tuple2 modifyText(final String nodeId, final String text) {
        final Tuple2[] result = new Tuple2[1];
        ThreadUtils.syncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IG2DNode node;
                Map<Long, IG2DNode> map = SceneGraphWebalizer.this.nodeMap;
                synchronized (map) {
                    node = SceneGraphWebalizer.this.nodeMap.get(Long.parseLong(nodeId));
                }
                if (node instanceof TextNode) {
                    TextNode n = (TextNode)node;
                    String error = n.editText(text);
                    result[0] = new Tuple2((Object)n.getText(), (Object)error);
                }
            }
        });
        return result[0];
    }

    public void deleteElements(WriteGraph graph, List<String> ids) throws DatabaseException {
        graph.markUndoPoint();
        for (String id : ids) {
            Resource res = this.elementIdToElement((ReadGraph)graph, id);
            RemoveElement.removeElement((WriteGraph)graph, (Resource)this.diagram, (Resource)res);
        }
    }

    public void addElements(final List<String> ids, double x, double y) throws DatabaseException {
        IDiagram d = (IDiagram)this.ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        final GraphToDiagramSynchronizer synchronizer = ((DiagramSceneGraphProvider)this.provider).getGraphToDiagramSynchronizer();
        List ecs = (List)Simantics.getSession().sync((ReadInterface)new UniqueRead<List<ElementClass>>(){

            public List<ElementClass> perform(ReadGraph graph) throws DatabaseException {
                ArrayList<ElementClass> ecs = new ArrayList<ElementClass>();
                SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                for (String id : ids) {
                    ElementClass ec;
                    Resource elementType = ss.getResource(Long.parseLong(id));
                    if (elementType == null || (ec = synchronizer.getNodeClass((RequestProcessor)graph, elementType)) == null) continue;
                    ecs.add(ec);
                }
                return ecs;
            }
        });
        DiagramUtils.mutateDiagram((IDiagram)d, m -> {
            if (this.ctx != null) {
                for (ElementClass ec : ecs) {
                    Point2D.Double pos = new Point2D.Double(x, y);
                    IElement element = m.newElement(ec);
                    IElement parent = (IElement)element.getHint(ElementHints.KEY_PARENT_ELEMENT);
                    if (parent != null) {
                        Point2D parentPos = ElementUtils.getPos((IElement)parent);
                        Point2D.Double pos2 = new Point2D.Double(((Point2D)pos).getX() - parentPos.getX(), ((Point2D)pos).getY() - parentPos.getY());
                        ElementUtils.setPos((IElement)element, (Point2D)pos2);
                        continue;
                    }
                    ElementUtils.setPos((IElement)element, (Point2D)pos);
                }
            }
        });
    }

    private void copyOrCutElements(final List<String> ids, final boolean cut) {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

            @Override
            public void run() {
                CopyPasteHandler cph = (CopyPasteHandler)SceneGraphWebalizer.this.ctx.getAtMostOneItemOfClass(CopyPasteHandler.class);
                try {
                    Collection elements = (Collection)Simantics.sync((ReadInterface)new UniqueRead<Collection<IElement>>(){

                        public Collection<IElement> perform(ReadGraph graph) throws DatabaseException {
                            ArrayList<IElement> result = new ArrayList<IElement>();
                            for (String elementId : ids) {
                                Resource er = SceneGraphWebalizer.this.elementIdToElement(graph, elementId);
                                IElement e = DiagramNodeUtil.findElement((ICanvasContext)(this).SceneGraphWebalizer.this.ctx, (Resource)er);
                                result.add(e);
                            }
                            return result;
                        }
                    });
                    Selection selection = (Selection)SceneGraphWebalizer.this.ctx.getAtMostOneItemOfClass(Selection.class);
                    selection.setSelection(0, elements);
                    cph.handleCommand(new CommandEvent(null, 0L, cut ? Commands.CUT : Commands.COPY));
                    selection.setSelection(0, Collections.emptySet());
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to copy/cut elements.", (Throwable)e);
                }
            }
        });
    }

    public void copyElements(List<String> ids) {
        this.copyOrCutElements(ids, false);
    }

    public void cutElements(List<String> ids) {
        this.copyOrCutElements(ids, true);
    }

    public void pasteElements(final double x, final double y) {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

            @Override
            public void run() {
                CopyPasteHandler cph = (CopyPasteHandler)SceneGraphWebalizer.this.ctx.getAtMostOneItemOfClass(CopyPasteHandler.class);
                MouseUtil mouseUtil = (MouseUtil)SceneGraphWebalizer.this.ctx.getSingleItem(MouseUtil.class);
                mouseUtil.handleMouseEvent((MouseEvent)new MouseEvent.MouseMovedEvent(null, 0L, 0, 0, 0, (Point2D)new Point2D.Double(x, y), null));
                cph.handleCommand(new CommandEvent(null, 0L, Commands.PASTE));
                Selection selection = (Selection)SceneGraphWebalizer.this.ctx.getAtMostOneItemOfClass(Selection.class);
                selection.setSelection(0, Collections.emptySet());
            }
        });
    }

    private static Resource resolveModel(ReadGraph graph, Resource diagram) throws DatabaseException {
        Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(diagram));
        if (model == null) {
            throw new ValidationException("no model found for composite " + NameUtils.getSafeName((ReadGraph)graph, (Resource)diagram));
        }
        return model;
    }

    private static String resolveRVI(ReadGraph graph, Resource model, Resource diagram) throws DatabaseException {
        ModelingResources mod = ModelingResources.getInstance((ReadGraph)graph);
        Resource composite = graph.getPossibleObject(diagram, mod.DiagramToComposite);
        if (composite == null) {
            return null;
        }
        ResourceArray compositePath = StructuralVariables.getCompositeArray((ReadGraph)graph, (Resource)composite);
        ResourceArray variablePath = compositePath.removeFromBeginning(1);
        return StructuralVariables.getRVI((ReadGraph)graph, (ResourceArray)variablePath);
    }

    public Resource getDiagram() {
        return this.diagram;
    }

    public void dispose() {
        this.listener.apply((Object)"reset", (Object)"{}");
        this.cleanUp();
    }

    public boolean isDisposed() {
        return this.ctx == null;
    }

    private void cleanUp() {
        if (this.activation != null) {
            this.activation.deactivate();
            this.activation = null;
        }
        if (this.ctx != null) {
            this.ctx.dispose();
            this.ctx = null;
        }
        if (this.provider != null) {
            this.provider.dispose();
            this.provider = null;
        }
        if (this.thread != null) {
            this.thread.stopDispatchingEvents(false);
            this.thread = null;
        }
    }

    public ICanvasContext getCanvasContext() {
        return this.ctx;
    }

    public ICanvasSceneGraphProvider getSceneGraphProvider() {
        return this.provider;
    }

    private void runMutex(Runnable r) {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)r);
    }

    public void configureDefaultTransformations(boolean value) {
        this.defaultTransformations = value;
    }

    public class ElementJSONImpl
    implements ElementJSON {
        Set<IHintContext.Key> rejectSet = new HashSet<IHintContext.Key>();

        public ElementJSONImpl() {
            this.rejectSet.add(ElementHints.KEY_IMAGE);
            this.rejectSet.add(ElementHints.KEY_COMPOSITE);
            this.rejectSet.add(ElementHints.KEY_DECORATORS);
            this.rejectSet.add(ElementHints.KEY_OBJECT);
            this.rejectSet.add(ElementHints.KEY_TRANSFORM);
            this.rejectSet.add(ElementHints.KEY_SG_NODE);
            this.rejectSet.add(ElementHints.KEY_PARENT_ELEMENT);
            this.rejectSet.add(ElementHints.KEY_COPY_OF_OBJECT);
            this.rejectSet.add(ElementHints.KEY_ANCHOR);
            this.rejectSet.add(ElementHints.KEY_FOCUS_LAYERS);
            this.rejectSet.add(ElementHints.KEY_VISIBLE_LAYERS);
            this.rejectSet.add(ElementHints.KEY_HOVER);
            this.rejectSet.add(ElementHints.KEY_TYPE_CLASS);
            this.rejectSet.add(ElementHints.KEY_SG_NAME);
            this.rejectSet.add(ElementHints.KEY_SG_CALLBACK);
            this.rejectSet.add(ElementHints.KEY_CONNECTION_ENTITY);
            this.rejectSet.add(SynchronizationHints.HINT_SYNCHRONIZER);
            this.rejectSet.add(TooltipParticipant.TOOLTIP_KEY);
            this.rejectSet.add(RouteGraphConnectionClass.KEY_PICK_TOLERANCE);
            this.rejectSet.add(RouteGraphConnectionClass.KEY_RENDERER);
            this.rejectSet.add(RouteGraphConnectionClass.KEY_RG_LISTENER);
            this.rejectSet.add(RouteGraphConnectionClass.KEY_RG_NODE);
            this.rejectSet.add(RouteGraphConnectionClass.KEY_ROUTEGRAPH);
            this.rejectSet.add(RouteGraphConnectionClass.KEY_USE_TOLERANCE_IN_SELECTION);
            this.rejectSet.add(Hints.KEY_DIRTY);
        }

        public void removedFromContext(ICanvasContext ctx) {
        }

        public void addedToContext(ICanvasContext ctx) {
        }

        public Optional<String> getJSON(IElement element) {
            ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
            for (Map.Entry entry : element.getHints().entrySet()) {
                JsonNode n;
                if (this.rejectSet.contains(entry.getKey()) || entry.getKey() instanceof TerminalKeyOf || entry.getValue() == null || entry.getValue() instanceof INode || entry.getValue() instanceof ICanvasContext || (n = SceneGraphWebalizer.this.mapper.valueToTree(entry.getValue())) == null) continue;
                String name = ((IHintContext.Key)entry.getKey()).toString();
                if (name.indexOf("(") > 0) {
                    name = name.substring(0, name.indexOf("("));
                } else {
                    name = name.replaceAll("(", "");
                    name = name.replaceAll(")", "");
                }
                node.set(name, n);
            }
            try {
                return Optional.of(SceneGraphWebalizer.this.mapper.writeValueAsString((Object)node));
            }
            catch (Exception exception) {
                return Optional.empty();
            }
        }
    }
}

