/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.web;

import java.util.HashSet;
import java.util.Set;
import org.simantics.db.Resource;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class DirtyElementsTracker
extends AbstractDiagramParticipant {
    private Set<IElement> dirtyElements = new HashSet<IElement>();
    private Set<Long> removedElements = new HashSet<Long>();
    private IDiagram diagram;
    private final ChangeListener changeListener = new ChangeListener();

    public synchronized Pair<Set<IElement>, Set<Long>> fetchChanges() {
        Pair result = new Pair(this.dirtyElements, this.removedElements);
        this.dirtyElements = new HashSet<IElement>();
        this.removedElements = new HashSet<Long>();
        return result;
    }

    public synchronized void reset() {
        this.dirtyElements.clear();
        if (this.diagram != null) {
            for (IElement e : this.diagram.getElements()) {
                this.dirtyElements.add(e);
            }
        }
        this.removedElements.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDirtyElement(IElement e) {
        DirtyElementsTracker dirtyElementsTracker = this;
        synchronized (dirtyElementsTracker) {
            this.dirtyElements.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemovedElement(IElement e) {
        DirtyElementsTracker dirtyElementsTracker = this;
        synchronized (dirtyElementsTracker) {
            Resource res = (Resource)ElementUtils.getObject((IElement)e);
            if (res != null) {
                this.removedElements.add(res.getResourceId());
            }
        }
    }

    protected void onDiagramSet(IDiagram newValue, IDiagram oldValue) {
        this.diagram = newValue;
        if (oldValue == newValue) {
            return;
        }
        if (oldValue != null) {
            for (IElement e : oldValue.getElements()) {
                this.removeElement(e);
            }
            oldValue.removeCompositionListener((IDiagram.CompositionListener)this.changeListener);
        }
        if (newValue != null) {
            for (IElement e : newValue.getElements()) {
                this.addElement(e);
                this.dirtyElements.add(e);
            }
            newValue.addCompositionListener((IDiagram.CompositionListener)this.changeListener);
        }
    }

    protected void addElement(IElement e) {
        e.addKeyHintListener(Hints.KEY_DIRTY, (IHintListener)this.changeListener);
    }

    protected void removeElement(IElement e) {
        e.removeKeyHintListener(Hints.KEY_DIRTY, (IHintListener)this.changeListener);
    }

    class ChangeListener
    implements IDiagram.CompositionListener,
    IHintListener {
        ChangeListener() {
        }

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            if (key == Hints.KEY_DIRTY && newValue == Hints.VALUE_SG_DIRTY && sender instanceof IElement) {
                DirtyElementsTracker.this.addDirtyElement((IElement)sender);
            }
        }

        public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
        }

        public void onElementAdded(IDiagram d, IElement e) {
            e.addHintListener((IHintListener)this);
            DirtyElementsTracker.this.addDirtyElement(e);
        }

        public void onElementRemoved(IDiagram d, IElement e) {
            e.removeHintListener((IHintListener)this);
            DirtyElementsTracker.this.addRemovedElement(e);
        }
    }
}

