/*******************************************************************************
 *  Copyright (c) 2023 Association for Decentralized Information Management
 *  in Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.web.serializer;

import java.awt.geom.Rectangle2D;
import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

/**
 * @author Jussi Koskela
 * @since 1.57.0
 */
public class RectangleSerializer extends StdSerializer<Rectangle2D> {
	private static final long serialVersionUID = -2748535131278907540L;

	public RectangleSerializer() {
		this(null);
	}

	public RectangleSerializer(Class<Rectangle2D> t) {
		super(t);
	}

	@Override
	public void serialize(Rectangle2D value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
		ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
		node.put("minX", value.getMinX());
		node.put("minY", value.getMinY());
		node.put("width", value.getWidth());
		node.put("height", value.getHeight());
		// jgen.writeString("rect2D(" + value.getMinX() + "," + value.getMinY() + "," +
		// value.getWidth() + "," + value.getHeight() + ")");
		jgen.writeObject(node);
	}

	@Override
	public void serializeWithType(Rectangle2D value, JsonGenerator gen, SerializerProvider serializers,
			TypeSerializer typeSer) throws IOException {
		// TODO Auto-generated method stub
		typeSer.writeTypePrefixForObject(value, gen);
		serialize(value, gen, serializers);
		typeSer.writeTypeSuffixForObject(value, gen);
	}
}