/*******************************************************************************
 *  Copyright (c) 2025 Association for Decentralized Information Management
 *  in Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.web.serializer;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.Locale;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

/**
 * @author Antti Villberg
 * @since 1.57.0
 */
public class FontSerializer extends StdSerializer<Font> {

	private static final long serialVersionUID = 7719241986258581681L;

	public FontSerializer() {
		this(null);
	}

	public FontSerializer(Class<Font> t) {
		super(t);
	}

	@Override
	public void serialize(Font value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
		ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
		node.put("name", value.getFamily());
		node.put("style", value.getStyle());
		node.put("size", value.getSize());
		// jgen.writeString("rect2D(" + value.getMinX() + "," + value.getMinY() + "," +
		// value.getWidth() + "," + value.getHeight() + ")");
		jgen.writeObject(node);
	}
}