/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.documents;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.Activator;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.FileUtils;
import org.simantics.utils.ui.ErrorLogger;

public class OpenPlainTextDocumentAdapter
extends AbstractResourceEditorAdapter {
    public OpenPlainTextDocumentAdapter() {
        super("Text Editor", Activator.COMPOSITE_ICON);
    }

    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        DocumentResource DOC = DocumentResource.getInstance((ReadGraph)g);
        return g.isInstanceOf(r, DOC.PlainTextDocument);
    }

    public void openEditor(final Resource r) throws Exception {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                String text;
                Layer0 L0 = Layer0.getInstance((ReadGraph)g);
                DocumentResource DOC = DocumentResource.getInstance((ReadGraph)g);
                String documentName = (String)g.getPossibleRelatedValue(r, L0.HasName);
                if (documentName == null) {
                    documentName = "";
                }
                if ((text = (String)g.getPossibleRelatedValue(r, DOC.PlainTextDocument_text, (Binding)Bindings.STRING)) == null) {
                    return;
                }
                try {
                    Resource model = (Resource)g.syncRequest((Read)new PossibleTypedParent(r, SimulationResource.getInstance((ReadGraph)g).Model));
                    String dir = model == null ? "" + r.getResourceId() : (String)g.getRelatedValue(model, L0.HasName);
                    IPath state = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.simantics.modeling.ui"));
                    final File stateDir = new File(state.toFile(), dir);
                    stateDir.mkdirs();
                    final File tempFile = new File(stateDir, FileUtils.escapeFileName((String)documentName) + ".txt");
                    FileUtils.writeFile((File)tempFile, (byte[])text.getBytes("US-ASCII"));
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                final IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                final IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (URI)tempFile.toURI(), (String)"org.eclipse.ui.DefaultTextEditor", (boolean)true);
                                page.addPartListener(new IPartListener(){

                                    public void partOpened(IWorkbenchPart part) {
                                    }

                                    public void partDeactivated(IWorkbenchPart part) {
                                    }

                                    public void partClosed(IWorkbenchPart part) {
                                        if (part == editor) {
                                            page.removePartListener((IPartListener)this);
                                            if (!PlatformUI.getWorkbench().isClosing()) {
                                                try {
                                                    FileUtils.deleteAll((File)stateDir);
                                                }
                                                catch (IOException e) {
                                                    ErrorLogger.defaultLogError((Throwable)e);
                                                }
                                            }
                                        }
                                    }

                                    public void partBroughtToTop(IWorkbenchPart part) {
                                    }

                                    public void partActivated(IWorkbenchPart part) {
                                    }
                                });
                            }
                            catch (Exception e) {
                                ErrorLogger.defaultLogError((Throwable)e);
                            }
                        }
                    });
                }
                catch (IOException e1) {
                    ErrorLogger.defaultLogError((Throwable)e1);
                }
            }
        });
    }
}

