/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.actions.Messages;
import org.simantics.scl.commands.Commands;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.utils.FileUtils;
import org.simantics.utils.ui.ErrorLogger;

public class ImportSVG
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart ap = HandlerUtil.getActivePart((ExecutionEvent)event);
        IEditorPart viewer = null;
        if (ap instanceof MultiPageEditorPart) {
            IEditorPart[] eps;
            block7: {
                MultiPageEditorPart rfe = (MultiPageEditorPart)ap;
                ResourceEditorInput in = (ResourceEditorInput)rfe.getEditorInput();
                final ResourceArray ra = in.getResourceArray();
                try {
                    ResourceArray symbolEditorInput = (ResourceArray)Simantics.getSession().syncRequest((Read)new Read<ResourceArray>(){

                        public ResourceArray perform(ReadGraph graph) throws DatabaseException {
                            StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
                            ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                            Resource symbol = graph.getPossibleObject(ra.resources[0], mr.ComponentTypeToSymbol);
                            Resource definedBy = symbol != null ? graph.getPossibleObject(symbol, sr.IsDefinedBy) : null;
                            ResourceArray result = definedBy != null ? new ResourceArray(new Resource[]{definedBy}) : ResourceArray.EMPTY;
                            return result;
                        }
                    });
                    eps = rfe.findEditors((IEditorInput)new ResourceEditorInput("org.simantics.modeling.ui.symbolEditor", symbolEditorInput));
                    if (eps.length != 0) break block7;
                    System.out.println("symbol editor part not found from multi page editor part: " + String.valueOf(ap));
                    return null;
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            viewer = eps[0];
        }
        if (ap instanceof IEditorPart) {
            viewer = (IEditorPart)ap;
        }
        ICanvasContext ctx = (ICanvasContext)viewer.getAdapter(ICanvasContext.class);
        if (ctx == null) {
            System.out.println("No canvas context");
            return null;
        }
        MouseUtil.MouseInfo minfo = ((MouseUtil)ctx.getSingleItem(MouseUtil.class)).getMousePressedInfo(0);
        if (minfo == null) {
            System.out.println("No mouse info");
            return null;
        }
        Point2D mpos = minfo.canvasPosition;
        IResourceEditorInput input = (IResourceEditorInput)viewer.getEditorInput();
        Resource composite = input.getResource();
        return ImportSVG.addSVG(mpos.getX(), mpos.getY(), composite);
    }

    public static Object addSVG(final double mposX, final double mposY, final Resource composite) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(shell);
        dialog.setText(Messages.ImportSVG_ChooseImportImage);
        dialog.setFilterExtensions(new String[]{"*.svg", "*.png"});
        final String filename = dialog.open();
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        try {
            final byte[] data = FileUtils.readFile((File)file);
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph g) throws DatabaseException {
                    Commands.get((ReadGraph)g, (String)"Simantics/Diagram/createSVGElement").execute((RequestProcessor)g, (Resource)g.syncRequest((Read)new IndexRoot(composite)), new Object[]{composite, ImportSVG.suffix(filename), data, mposX, mposY});
                }
            });
        }
        catch (FileNotFoundException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return null;
    }

    private static String suffix(String fileName) {
        int len = fileName.length();
        if (len < 3) {
            return null;
        }
        return fileName.substring(len - 3, len).toLowerCase();
    }
}

