/*******************************************************************************
 * Copyright (c) 2007, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - page numbering additions
 *******************************************************************************/
package org.simantics.modeling.ui.pdf;

import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;

import org.eclipse.ui.IMemento;
import org.simantics.utils.ui.workbench.StringMemento;

/**
 * @author Tuukka Lehtonen
 */
public class Preferences {

    public static final String DIAGRAM_EXPORT_PDF_PATH = "diagram.export.pdf.path"; //$NON-NLS-1$

    public static final String DIAGRAM_EXPORT_PDF_ZOOM_TO_FIT = "diagram.export.pdf.zoomToFit"; //$NON-NLS-1$
    public static final String DIAGRAM_EXPORT_PDF_ATTACH_TG = "diagram.export.pdf.attachTG"; //$NON-NLS-1$
    public static final String DIAGRAM_EXPORT_PDF_INCLUDE_DIAGRAMS = "diagram.export.pdf.includeDiagrams"; //$NON-NLS-1$
    public static final String DIAGRAM_EXPORT_PDF_INCLUDE_DOCUMENTATION = "diagram.export.pdf.includeDoc"; //$NON-NLS-1$
    public static final String DIAGRAM_EXPORT_PDF_INCLUDE_COMPONENT_LEVEL_DOCUMENTATION = "diagram.export.pdf.includeComponentLevelDoc"; //$NON-NLS-1$
    public static final String DIAGRAM_EXPORT_PDF_ADD_PAGE_NUMBERS = "diagram.export.pdf.addPageNumbers"; //$NON-NLS-1$

    private static final String TAG_PATH  = "path"; //$NON-NLS-1$
    private static final String ATTR_NAME = "name"; //$NON-NLS-1$

    public static Deque<String> decodePaths(String recentPathsPref) {
        Deque<String> result = new LinkedList<>();
        try {
            StringMemento sm = new StringMemento(recentPathsPref);
            for (IMemento m : sm.getChildren(TAG_PATH)) {
                String name = m.getString(ATTR_NAME);
                if (name != null && !name.isEmpty())
                    result.add(name);
            }
        } catch (IllegalArgumentException e) {
        }
        return result;
    }

    public static String encodePaths(Deque<String> recentPaths) {
        StringMemento sm = new StringMemento();
        for (String path : recentPaths) {
            IMemento m = sm.createChild(TAG_PATH);
            m.putString(ATTR_NAME, path);
        }
        return sm.toString();
    }

    public static Deque<String> addFirstRemovingDuplicates(Deque<String> deque, String add, int truncateToMaxItems) {
        deque.addFirst(add);

        // Remove all duplicates
        var dups = new HashSet<>();
        for (var it = deque.iterator(); it.hasNext();) {
            String path = it.next();
            if (!dups.add(path)) {
                it.remove();
            }
        }

        // Truncate
        while (deque.size() > truncateToMaxItems)
            deque.pollLast();

        return deque;
    }

}