/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor.handlers;

import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * @author Tuukka Lehtonen
 */
public class ToggleFocusabilityHandler extends AbstractHandler implements IElementUpdater {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		ILayersEditor le = getLayers();
		if (le != null) {
			boolean b = le.getIgnoreFocusSettings();
			le.setIgnoreFocusSettings( !b );

			ICommandService service = (ICommandService) PlatformUI.getWorkbench().getService(ICommandService.class);
			service.refreshElements(event.getCommand().getId(), null);
		}
		return null;
	}

	@SuppressWarnings("rawtypes")
	@Override
	public void updateElement(UIElement element, Map parameters) {
		//System.out.println("updateElement: " + element);
		DiagramEditor editor = getEditor();
		if (editor != null) {
			//System.out.println("updateElement2: " + editor);
			ILayersEditor le = getLayers(editor);
			if (le != null) {
				boolean bool = le.getIgnoreFocusSettings();
				//System.out.println("get ignore focus setting: " + bool);
				element.setChecked(bool);
				element.setTooltip((bool ? "Deny" : "Allow") + " Focusing and Editing of Images");
				return;
			}
		}
	}

	protected ILayersEditor getLayers() {
		DiagramEditor editor = getEditor();
		if (editor == null)
			return null;
		return getLayers(editor);
	}

	protected ILayersEditor getLayers(DiagramEditor editor) {
		// The diagram might not be available since the diagram editor loads it asynchronously.
		IDiagram diagram = (IDiagram) editor.getAdapter(IDiagram.class);
		if (diagram == null)
			return null;
		//System.out.println("getLayersEditor(" + diagram + ")");
		ILayersEditor le = diagram.getHint(DiagramHints.KEY_LAYERS_EDITOR);
		return le;
	}

	protected DiagramEditor getEditor() {
		IEditorPart editorPart = WorkbenchUtils.getActiveEditor();
		if (editorPart == null)
			return null;
		if (editorPart instanceof DiagramEditor) {
			DiagramEditor editor = (DiagramEditor) editorPart;
			return editor;
		}
		return null;
	}

}
