/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.chart.property;

import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 */
public class ObtainedDoubleStringAdapter extends SimpleContextualAdapter<String, RelationContext> {

    private static final ObtainedDoubleAdapter ADAPTER = new ObtainedDoubleAdapter();

    @Override
    public String adapt(ReadGraph graph, Resource source, RelationContext context) throws DatabaseException {
        Double value = ADAPTER.adapt(graph, source, context);
        return value != null ? value.toString() : ""; //$NON-NLS-1$
    }

}
