/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.diagram.adapter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.function.All;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scenegraph.g2d.nodes.spatial.RTreeNode;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.utils.page.PageOrientation;

public class DrawingBorderStyle
extends StyleBase<StyleInfo> {
    private static final String BORDER_NODE = "template>border";
    private static int TOP_INDEX = 0;
    private static int RIGHT_INDEX = 1;
    private static int BOTTOM_INDEX = 2;
    private static int LEFT_INDEX = 3;
    private static int HEIGHT_INDEX = 1;
    private static int WIDTH_INDEX = 0;

    public StyleInfo calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem, Variable activeComposite) throws DatabaseException {
        Resource page;
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        StyleInfo info = new StyleInfo();
        info.template = All.getTemplate((ReadGraph)graph, (Resource)runtimeDiagram);
        if (info.template == null) {
            return null;
        }
        info.margin = (float[])graph.getPossibleRelatedValue(info.template, TEMPLATE2D.HasMargin, (Binding)Bindings.FLOAT_ARRAY);
        if (info.margin == null) {
            return null;
        }
        info.padding = (float[])graph.getPossibleRelatedValue(info.template, TEMPLATE2D.HasPadding, (Binding)Bindings.FLOAT_ARRAY);
        Resource orientation = graph.getPossibleObject(info.template, TEMPLATE2D.HasPageOrientation);
        info.orientation = PageOrientation.Portrait;
        if (orientation != null && orientation.equals(TEMPLATE2D.PageOrientation_Landscape)) {
            info.orientation = PageOrientation.Landscape;
        }
        if ((page = graph.getPossibleObject(info.template, TEMPLATE2D.HasPage)) == null) {
            return null;
        }
        Resource border = graph.getPossibleObject(info.template, TEMPLATE2D.HasBorder);
        if (border == null) {
            return null;
        }
        info.pageSize = (float[])graph.getPossibleRelatedValue(page, TEMPLATE2D.HasSize, (Binding)Bindings.FLOAT_ARRAY);
        if (info.pageSize == null) {
            return null;
        }
        Resource rColor = graph.getPossibleObject(border, G2D.HasColor);
        Color color = null;
        if (rColor != null) {
            color = (Color)G2DUtils.getObject((ReadGraph)graph, (Resource)rColor);
        }
        if (color == null) {
            color = new Color(0, 0, 0);
        }
        info.rgba = new float[4];
        color.getRGBComponents(info.rgba);
        info.borderSize = (float[])graph.getPossibleRelatedValue(border, TEMPLATE2D.HasSize, (Binding)Bindings.FLOAT_ARRAY);
        if (info.borderSize == null) {
            return null;
        }
        return info;
    }

    public void applyStyleForItem(EvaluationContext evaluationContext, DataNodeMap map, Object item, StyleInfo info) {
        float tmp;
        if (info == null) {
            return;
        }
        float[] pageSize = info.pageSize;
        float[] margin = this.extract(info.margin);
        float[] borderSize = this.extract(info.borderSize);
        if (pageSize == null || pageSize.length != 2 || margin == null || borderSize == null) {
            return;
        }
        if (info.orientation == PageOrientation.Portrait && pageSize[WIDTH_INDEX] > pageSize[HEIGHT_INDEX]) {
            tmp = pageSize[HEIGHT_INDEX];
            pageSize[DrawingBorderStyle.HEIGHT_INDEX] = pageSize[WIDTH_INDEX];
            pageSize[DrawingBorderStyle.WIDTH_INDEX] = tmp;
        }
        if (info.orientation == PageOrientation.Landscape && pageSize[WIDTH_INDEX] < pageSize[HEIGHT_INDEX]) {
            tmp = pageSize[HEIGHT_INDEX];
            pageSize[DrawingBorderStyle.HEIGHT_INDEX] = pageSize[WIDTH_INDEX];
            pageSize[DrawingBorderStyle.WIDTH_INDEX] = tmp;
        }
        Line2D[] borders = new Line2D[4];
        borders[DrawingBorderStyle.TOP_INDEX] = new Line2D.Float(margin[LEFT_INDEX], margin[TOP_INDEX] + borderSize[TOP_INDEX] / 2.0f, pageSize[WIDTH_INDEX] - margin[RIGHT_INDEX], margin[TOP_INDEX] + borderSize[TOP_INDEX] / 2.0f);
        borders[DrawingBorderStyle.BOTTOM_INDEX] = new Line2D.Float(margin[LEFT_INDEX], pageSize[HEIGHT_INDEX] - margin[BOTTOM_INDEX] - borderSize[BOTTOM_INDEX] / 2.0f, pageSize[WIDTH_INDEX] - margin[RIGHT_INDEX], pageSize[HEIGHT_INDEX] - margin[BOTTOM_INDEX] - borderSize[BOTTOM_INDEX] / 2.0f);
        borders[DrawingBorderStyle.LEFT_INDEX] = new Line2D.Float(margin[LEFT_INDEX] + borderSize[LEFT_INDEX] / 2.0f, margin[TOP_INDEX] + borderSize[TOP_INDEX] / 2.0f, margin[LEFT_INDEX] + borderSize[LEFT_INDEX] / 2.0f, pageSize[HEIGHT_INDEX] - margin[BOTTOM_INDEX] - borderSize[BOTTOM_INDEX] / 2.0f);
        borders[DrawingBorderStyle.RIGHT_INDEX] = new Line2D.Float(pageSize[WIDTH_INDEX] - margin[RIGHT_INDEX] - borderSize[RIGHT_INDEX] / 2.0f, margin[TOP_INDEX] + borderSize[TOP_INDEX] / 2.0f, pageSize[WIDTH_INDEX] - margin[RIGHT_INDEX] - borderSize[RIGHT_INDEX] / 2.0f, pageSize[HEIGHT_INDEX] - margin[BOTTOM_INDEX] - borderSize[BOTTOM_INDEX] / 2.0f);
        G2DSceneGraph sg = evaluationContext.getSceneGraph();
        if (sg == null) {
            return;
        }
        G2DParentNode nav = (G2DParentNode)sg.getNode("navigation");
        if (nav == null) {
            return;
        }
        this.cleanupStyleForItem(evaluationContext, map, item);
        RTreeNode pageTemplate = (RTreeNode)ProfileVariables.claimChild((INode)evaluationContext.getSceneGraph(), (String)"navigation", (String)BORDER_NODE, RTreeNode.class, (Observer)evaluationContext);
        if (pageTemplate == null) {
            return;
        }
        pageTemplate.setZIndex(1);
        int i = 0;
        while (i < 4) {
            Line2D line = borders[i];
            if (!(borderSize[i] < 0.0f)) {
                BasicStroke stroke = new BasicStroke(borderSize[i], 0, 0);
                ShapeNode shape = (ShapeNode)pageTemplate.addNode("border_" + i, ShapeNode.class);
                shape.setShape((Shape)line);
                shape.setScaleStroke(false);
                shape.setStroke((Stroke)stroke);
                shape.setFill(false);
                shape.setColor((Paint)new Color(info.rgba[0], info.rgba[1], info.rgba[2], info.rgba[3]));
                if (i == TOP_INDEX || i == BOTTOM_INDEX) {
                    shape.setZIndex(10);
                }
            }
            ++i;
        }
    }

    protected void cleanupStyleForItem(EvaluationContext evaluationContext, DataNodeMap map, Object item) {
        ProfileVariables.denyChild((INode)evaluationContext.getSceneGraph(), (String)"navigation", (String)BORDER_NODE);
    }

    public String toString() {
        return "Border style";
    }

    private float[] extract(float[] settings) {
        float[] ret = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        if (settings == null || settings.length == 0 || settings.length > 4) {
            return null;
        }
        if (settings.length == 1) {
            ret[DrawingBorderStyle.TOP_INDEX] = settings[0];
            ret[DrawingBorderStyle.BOTTOM_INDEX] = settings[0];
            ret[DrawingBorderStyle.LEFT_INDEX] = settings[0];
            ret[DrawingBorderStyle.RIGHT_INDEX] = settings[0];
        }
        if (settings.length == 2) {
            ret[DrawingBorderStyle.TOP_INDEX] = settings[0];
            ret[DrawingBorderStyle.BOTTOM_INDEX] = settings[0];
            ret[DrawingBorderStyle.LEFT_INDEX] = settings[1];
            ret[DrawingBorderStyle.RIGHT_INDEX] = settings[1];
        }
        if (settings.length == 3) {
            ret[DrawingBorderStyle.TOP_INDEX] = settings[0];
            ret[DrawingBorderStyle.BOTTOM_INDEX] = settings[2];
            ret[DrawingBorderStyle.LEFT_INDEX] = settings[1];
            ret[DrawingBorderStyle.RIGHT_INDEX] = settings[1];
        }
        if (settings.length == 4) {
            ret[DrawingBorderStyle.TOP_INDEX] = settings[0];
            ret[DrawingBorderStyle.RIGHT_INDEX] = settings[1];
            ret[DrawingBorderStyle.BOTTOM_INDEX] = settings[2];
            ret[DrawingBorderStyle.LEFT_INDEX] = settings[3];
        }
        return ret;
    }

    public static class StyleInfo
    extends Bean {
        @Optional
        public float[] pageSize = null;
        @Optional
        public float[] margin = null;
        @Optional
        public float[] borderSize = null;
        @Optional
        public float[] padding = null;
        @Optional
        public PageOrientation orientation = null;
        @Optional
        public float[] rgba = null;
        @Optional
        public Resource template = null;
    }
}

