/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.function;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

import org.simantics.browsing.ui.model.modifiers.NoModifierRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.content.ElementContext;
import org.simantics.diagram.function.PredefinedVariables;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scenegraph.profile.request.RuntimeProfileActiveEntryResources;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.utils.ui.ISelectionUtils;


public class All {

    @SCLValue(type = "a -> b -> c")
    public static Object variableTransformation(Object _graph, Object input) throws DatabaseException {

        ReadGraph graph = (ReadGraph) _graph;

        Resource object = ISelectionUtils.getSinglePossibleKey(input, SelectionHints.KEY_MAIN, Resource.class);
        if (object == null)
            return null;

        Resource runtime = ISelectionUtils.getSinglePossibleKey(input, SelectionHints.KEY_VARIABLE_RESOURCE,
                Resource.class);
        if (runtime == null)
            return null;

        Variable inputVariable = graph.syncRequest(new UnaryRead<Resource, Variable>(runtime) {

            @Override
            public Variable perform(ReadGraph graph) throws DatabaseException {

                DiagramResource dr = DiagramResource.getInstance(graph);
                String diagramVariable = graph.getPossibleRelatedValue(parameter, dr.RuntimeDiagram_HasVariable);
                return Variables.getVariable(graph, diagramVariable);

            }

        });
        if (inputVariable == null)
            return null;

        Resource component = ModelingUtils.getPossibleElementCorrespondendence(graph, object);
        if (component == null)
            return null;
        return inputVariable.browsePossible(graph, component);

    }

    @SCLValue(type = "a -> b -> c")
    public static Object resourceVariableTransformation(Object _graph, Object input) throws DatabaseException {

        ReadGraph graph = (ReadGraph) _graph;

        Resource object = ISelectionUtils.getSinglePossibleKey(input, SelectionHints.KEY_MAIN, Resource.class);
        if (object == null)
            return null;
        
        return Variables.getVariable(graph, object);

//        Resource runtime = ISelectionUtils.getSinglePossibleKey(input, SelectionHints.KEY_VARIABLE_RESOURCE,
//                Resource.class);
//        if (runtime == null)
//            return null;
//
//        Variable inputVariable = graph.syncRequest(new UnaryRead<Resource, Variable>(runtime) {
//
//            @Override
//            public Variable perform(ReadGraph graph) throws DatabaseException {
//
//                DiagramResource dr = DiagramResource.getInstance(graph);
//                String diagramVariable = graph.getPossibleRelatedValue(parameter, dr.RuntimeDiagram_HasVariable);
//                return Variables.getVariable(graph, diagramVariable);
//
//            }
//
//        });
//        if (inputVariable == null)
//            return null;
//
//        Resource component = ModelingUtils.getPossibleElementCorrespondendence(graph, object);
//        if (component == null)
//            return null;
//        return inputVariable.browsePossible(graph, component);

    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> String")
    public static String variableReference(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {

        Template2dResource TEMPLATE2D = Template2dResource.getInstance(graph);

//        System.out.println("CONTEXT: " + context.getURI(graph));
//        Resource runtime = ScenegraphLoaderUtils.getRuntime(graph, context);
//        System.out.println("runtime: " + NameUtils.getSafeName(graph, runtime));

        String path = graph.getRelatedValue(converter, TEMPLATE2D.Profiles_VariableReference_path, Bindings.STRING);
        if (path == null)
            return null;

        Variable selection = ScenegraphLoaderUtils.getPossibleVariableSelection(graph, context);
        PredefinedVariables vars = PredefinedVariables.getInstance();
        Variable property = vars.getVariable(graph, path, converter, selection);
        if (property != null)
            return property.getValue(graph).toString();

        return null;
    }

    public static Resource getTemplate(ReadGraph graph, Resource runtimeDiagram) throws DatabaseException {
        Template2dResource TEMPLATE2D = Template2dResource.getInstance(graph);
        DiagramResource DIA = DiagramResource.getInstance(graph);
        Resource diagram = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
        if (diagram != null) {
            Resource template = graph.getPossibleObject(diagram, TEMPLATE2D.HasDrawingTemplate);
            if (template != null)
                return template;
        }
        return null;
	}

	@SCLValue(type = "ReadGraph -> Resource -> ElementContext -> a")
    public static Object flagTransform(ReadGraph graph, Resource converter, ElementContext context) throws DatabaseException {
		//Layer0 L0 = Layer0.getInstance(graph);
		DiagramResource DIA = DiagramResource.getInstance(graph);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance(graph);

		Resource flag = context.element;
		Resource runtimeDiagram = context.runtime;

		Resource diagram = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
		if (diagram == null)
			return org.simantics.diagram.function.All.flagTransform(graph, converter, context);

		Resource template = getTemplate(graph, runtimeDiagram);
		if (template == null)
			return org.simantics.diagram.function.All.flagTransform(graph, converter, context);

		double gridSize = DiagramGraphUtil.getGridSize(graph, diagram, 0.0);

		String tableName = graph.getPossibleRelatedValue(flag, DIA.Flag_HasIOTableBinding, Bindings.STRING);
		Integer rowIndex = graph.getPossibleRelatedValue(flag, DIA.Flag_HasIOTableRowIndex, Bindings.INTEGER);
		FlagInfo flagInfo = new FlagInfo();
		flagInfo.flag = flag;
		if (tableName != null && tableName.length() > 0)
			flagInfo.flagTableName = tableName;
		flagInfo.flagTableRowIndex = rowIndex;
		
		Map<String, FlagTableInfo> name2table = graph.syncRequest(new DrawingTemplateInfo(template), TransientCacheListener.<TreeMap<String, FlagTableInfo>> instance());
        if (name2table == null)
        	name2table = Collections.emptyMap();
        
        if (!name2table.containsKey(flagInfo.flagTableName))
        	return org.simantics.diagram.function.All.flagTransform(graph, converter, context);
        
        double[] mat = graph.getRelatedValue(flag, DIA.HasTransform, Bindings.DOUBLE_ARRAY);
		TranslateFlag com = new TranslateFlag(flagInfo, name2table, mat, gridSize);
		
    	boolean isIOTablesActive = false;
        for (Resource entry : graph.syncRequest(new RuntimeProfileActiveEntryResources(runtimeDiagram))) {
        	//ProfileEntry profile = graph.adapt(entry, ProfileEntry.class);
        	if (TEMPLATE2D.Profiles_DrawingFlagTables.equals(entry)){
        		isIOTablesActive = true;
        		break;
        	}
        }

        if (isIOTablesActive)
        	return com.perform();
        return org.simantics.diagram.function.All.flagTransform(graph, converter, context);
    }

    @SCLValue(type = "ReadGraph -> Resource -> a -> b")
    public static Object variableReferencePath(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        if (context instanceof Variable) {
            // Input variable is (:VariableReference)#HasDisplayValue. Need to
            // go to parent to find the variable to be edited.
            //System.out.println("R: " + NameUtils.getSafeName(graph, resource));
            //System.out.println("V: " + ((Variable) context).getURI(graph));
            Variable document = ((Variable)context).browse(graph, ".");
            //System.out.println("D: " + document.getURI(graph));
            String path = document.getPossiblePropertyValue(graph, "path", Bindings.STRING);
            return path;
        }
        return null;
    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> b")
    public static Object variableReferenceModifier(ReadGraph graph, Resource resource, final Variable context) throws DatabaseException {
        return NoModifierRule.NO_MODIFIER;
    }

}