/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.ontology.ScenegraphResources;

public class FixLinkedList implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if(!(target instanceof Resource))
            return null;
        final Resource parent = (Resource)target;

        return new Runnable() {
            @Override
            public void run() {
                Simantics.getSession().asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                        Layer0 L0 = Layer0.getInstance(g);
                        ScenegraphResources SG = ScenegraphResources.getInstance(g);

                        Collection<Resource> consist = g.syncRequest(new ObjectsWithType(parent, L0.ConsistsOf, SG.Node));

                        Resource list = g.getPossibleObject(parent, SG.Node_children);
                        if (list != null) {
                            try {
                                List<Resource> children = ListUtils.toList(g, list);
                                Set<Resource> childSet = new HashSet<Resource>(children);
                                Set<Resource> consistSet = new HashSet<Resource>(consist);
                                if (childSet.equals(consistSet)) {
                                    return;
                                }
                            } catch (DatabaseException e) {
                            }

                            // List is invalid, recreate it.
                            RemoverUtil.remove(g, list);
                            g.deny(parent, SG.Node_children);
                            list = ListUtils.create(g, consist);
                            g.claim(parent, SG.Node_children, list);

                        } else {
                            // No list at all - create one from children.
                            list = ListUtils.create(g, consist);
                            g.claim(parent, SG.Node_children, list);
                        }
                    }
                });
            }
        };
    }
}
