package org.simantics.modeling.utils;

import java.util.ArrayList;
import java.util.List;

import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableReference;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.modeling.PropertyVariables;

/**
 * A intermediate hack solution for converting variables to variable references.
 * {@link NodeReference}s and {@link Datatype}s for subscription and charting
 * purposes.
 * 
 * @author Tuukka Lehtonen
 */
public final class VariableReferences {

    public static Read<List<VariableReference>> toReferences(final List<PropertyVariables> vars) {
        return toReferences(null, vars);
    }

    public static Read<List<VariableReference>> toReferences(final Resource expectedModel, final List<PropertyVariables> vars) {
        return new Read<List<VariableReference>>() {
            @Override
            public List<VariableReference> perform(ReadGraph graph) throws DatabaseException {
                List<VariableReference> result = new ArrayList<VariableReference>();
                for (PropertyVariables v : vars) {
                    if (expectedModel != null) {
                        // Check that the model of the variable matches the target model.
                        Resource model = Variables.getModel(graph, v.getContainer());
                        if (!ObjectUtils.objectEquals(expectedModel, model))
                            continue;
                    }

                    Datatype datatype = v.getVisualVariable().getPossibleDatatype(graph);

//                    System.out.println("URI1: " + v.getContainer().getURI(graph));
//                    System.out.println("URI2: " + v.getExperiment().getURI(graph));
//                    System.out.println("URI3: " + v.getProperty().getURI(graph));
//                    System.out.println("RVI: " + Variables.getRVI(graph, v.getProperty()));
                    RVI rvi = Variables.getRVI2(graph, v.getVisualVariable());
//                    String rvi = Variables.getRVI(graph, v.getVisualVariable());
//                    String nodeReference = rvi.replaceFirst("/", "");
//                    System.out.println("NODEREF: " + nodeReference);
//                    System.out.println("DATATYPE: " + datatype);
                    result.add( VariableReference.of( rvi, datatype, null ) );
                }
                return result;
            }
        };
    }

    public static Read<List<VariableReference>> variablesToReferences(final List<Variable> vars) {
        return variablesToReferences((Resource) null, vars);
    }

    public static Read<List<VariableReference>> variablesToReferences(final Resource expectedModel, final List<Variable> vars) {
        return new Read<List<VariableReference>>() {
            @Override
            public List<VariableReference> perform(ReadGraph graph) throws DatabaseException {
                List<VariableReference> result = new ArrayList<VariableReference>();
                for (Variable v : vars) {
                    if (expectedModel != null) {
                        // Check that the model of the variable matches the target model.
                        Resource model = Variables.getModel(graph, v);
                        if (!ObjectUtils.objectEquals(expectedModel, model))
                            continue;
                    }
                    
                    List<VariableReference> refs = v.getPossiblePropertyValue(graph, "variableReferences");
                    if(refs != null) {
                        result.addAll( refs );
                        continue;
                    }
                    
                    Datatype datatype = v.getPossibleDatatype(graph);
                    RVI rvi = Variables.getRVI2(graph, v);
//                    String rvi = Variables.getRVI(graph, v);
//                    String nodeReference = rvi.replaceFirst("/", "");
                    result.add( VariableReference.of( rvi, datatype, null ) );
                }
                return result;
            }
        };
    }

}
