/*******************************************************************************
 * Copyright (c) 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.adapters;

import org.simantics.db.Metadata;
import org.simantics.db.Session;
import org.simantics.modeling.utils.OntologicalRequirementTracker;

/**
 * A tagging metadata entry that is used for marking a graph transaction as one
 * that should not be processed by change history update mechanisms.
 * 
 * @author Tuukka Lehtonen
 * @see OntologicalRequirementTracker
 */
public class SkipChangeHistoryUpdate implements Metadata {

	@Override
	public byte[] serialise(Session session) {
		return new byte[0];
	}

	public static SkipChangeHistoryUpdate deserialise(Session session, byte[] input) {
		return new SkipChangeHistoryUpdate();
	}

}
