/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.util;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.history.HistoryException;
import org.simantics.history.util.Stream;
import org.simantics.history.util.ValueBand;

public class StreamIterator {
    RecordBinding sampleBinding;
    ArrayAccessor aa;
    Stream stream;
    double from;
    double end;
    Object current;
    Object next;
    ValueBand valueBand;
    ValueBand nextValueBand;
    double startTime;
    double endTime;
    int index = -1;
    int size;

    public StreamIterator(ArrayAccessor aa) throws HistoryException {
        try {
            this.aa = aa;
            this.sampleBinding = (RecordBinding)Bindings.getBeanBinding((Datatype)aa.type().componentType);
            this.current = this.sampleBinding.createDefault();
            this.next = this.sampleBinding.createDefault();
            this.valueBand = new ValueBand((Binding)this.sampleBinding, this.current);
            this.nextValueBand = new ValueBand((Binding)this.sampleBinding, this.next);
            this.stream = new Stream(aa, this.sampleBinding);
            this.size = aa.size();
            if (this.size > 0) {
                aa.get(0, (Binding)this.sampleBinding, this.current);
                this.from = this.valueBand.getTimeDouble();
                aa.get(this.size - 1, (Binding)this.sampleBinding, this.current);
                this.end = this.valueBand.hasEndTime() ? this.valueBand.getEndTimeDouble() : this.valueBand.getTimeDouble();
            }
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
        catch (AccessorException e) {
            throw new HistoryException(e);
        }
    }

    public boolean gotoTime(double time) throws HistoryException {
        if (time < this.from || time > this.end) {
            this.index = -1;
            return false;
        }
        if (time >= this.startTime && time < this.endTime) {
            return this.hasValue();
        }
        int i = this.stream.binarySearch((Binding)Bindings.DOUBLE, time);
        if (i >= 0) {
            this.gotoIndex(i);
        } else {
            int insertPos = -i - 2;
            if (insertPos < 0 || insertPos >= this.size) {
                this.index = -1;
            } else {
                this.gotoIndex(insertPos);
                if (this.endTime < time) {
                    this.index = -1;
                }
            }
        }
        return this.hasValue();
    }

    /*
     * Unable to fully structure code
     */
    public boolean proceedToTime(double time) throws HistoryException {
        if (time < this.from || time > this.end) {
            this.index = -1;
            return false;
        }
        if (this.index >= 0 && !(this.startTime > time)) ** GOTO lbl9
        this.gotoTime(time);
        return this.hasValue();
lbl-1000:
        // 1 sources

        {
            this.gotoIndex(this.index + 1);
lbl9:
            // 2 sources

            ** while (time >= this.endTime && this.hasNext())
        }
lbl10:
        // 1 sources

        return this.hasValue();
    }

    public void gotoIndex(int pos) throws HistoryException {
        if (pos == this.index) {
            return;
        }
        if (pos < 0 || pos >= this.size) {
            this.index = -1;
            return;
        }
        try {
            if (pos == this.index + 1 && this.index >= 0) {
                this.sampleBinding.readFrom((Binding)this.sampleBinding, this.next, this.current);
            } else {
                this.aa.get(pos, (Binding)this.sampleBinding, this.current);
            }
            this.startTime = this.valueBand.getTimeDouble();
            if (pos + 1 < this.size) {
                this.aa.get(pos + 1, (Binding)this.sampleBinding, this.next);
                this.endTime = this.nextValueBand.getTimeDouble();
            } else {
                this.endTime = this.valueBand.hasEndTime() ? this.valueBand.getEndTimeDouble() : this.valueBand.getTimeDouble();
            }
            this.index = pos;
        }
        catch (AccessorException e) {
            throw new HistoryException(e);
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
    }

    public boolean hasNext() {
        return this.index < this.size - 1;
    }

    public void next() throws HistoryException {
        this.gotoIndex(this.index + 1);
    }

    public ValueBand getValueBand() {
        return this.valueBand;
    }

    public Object getValue(Binding binding) throws HistoryException {
        return this.valueBand.getValue(binding);
    }

    public Object getSample() {
        return this.current;
    }

    public RecordBinding getSampleBinding() {
        return this.sampleBinding;
    }

    public boolean hasValue() {
        return this.index != -1;
    }

    public boolean hasValidValue() throws HistoryException {
        return this.index != -1 && !this.valueBand.isNanSample() && !this.valueBand.isNullValue();
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public Double getNextTime() throws HistoryException {
        if (this.size == 0) {
            return null;
        }
        if (this.index == -1) {
            return this.from;
        }
        return (Double)this.nextValueBand.getTime((Binding)Bindings.DOUBLE);
    }

    public Double getNextTime(double currentTime) throws HistoryException {
        Double endTime;
        if (this.size == 0) {
            return null;
        }
        if (this.index == -1) {
            return this.from;
        }
        if (this.valueBand.hasEndTime() && (endTime = (Double)this.valueBand.getEndTime((Binding)Bindings.DOUBLE)) > currentTime) {
            return endTime;
        }
        double nextTime = (Double)this.nextValueBand.getTime((Binding)Bindings.DOUBLE);
        return nextTime;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        String valueStr;
        Binding valueBinding = this.valueBand.getValueBinding();
        try {
            valueStr = valueBinding.toString(this.valueBand.getValue());
        }
        catch (BindingException e) {
            valueStr = e.toString();
        }
        catch (HistoryException e) {
            valueStr = e.toString();
        }
        if (this.hasValue()) {
            return "i=" + this.index + ", time=[" + this.startTime + "-" + this.endTime + "], value=" + valueStr;
        }
        return "<no value>";
    }

    public double getFirstTime() {
        return this.from;
    }

    public double getLastTime() {
        return this.end;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

