/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.java.JavaArray;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.ArrayListBinding;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.ItemManager;

public class MemoryHistory
implements HistoryManager {
    Map<String, Item> items = new HashMap<String, Item>();
    private volatile transient ItemManager cachedItemManager;

    @Override
    public void create(Bean ... descs) throws HistoryException {
        Bean[] beanArray = descs;
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            Bean desc = beanArray[n2];
            try {
                String id = (String)desc.getField("id");
                Datatype format = (Datatype)desc.getField("format");
                Binding sampleBinding = Bindings.getBinding((Datatype)format);
                ArrayListBinding arrayBinding = new ArrayListBinding(sampleBinding);
                ArrayList array = new ArrayList();
                JavaArray sa = new JavaArray(null, (ArrayBinding)arrayBinding, array, AccessorParams.DEFAULT);
                Item item = new Item();
                item.stream = sa;
                item.desc = desc.clone();
                item.format = format;
                this.items.put(id, item);
                this.cachedItemManager = null;
            }
            catch (BindingException e) {
                throw new HistoryException("Invalid history item description", e);
            }
            ++n2;
        }
    }

    @Override
    public void delete(String ... itemIds) throws HistoryException {
        String[] stringArray = itemIds;
        int n = itemIds.length;
        int n2 = 0;
        while (n2 < n) {
            String itemId = stringArray[n2];
            try {
                Item i = this.items.remove(itemId);
                if (i == null) {
                    throw new HistoryException("Null item");
                }
                i.stream.close();
                this.cachedItemManager = null;
            }
            catch (AccessorException accessorException) {
                throw new HistoryException();
            }
            ++n2;
        }
    }

    @Override
    public void modify(Bean ... descs) throws HistoryException {
        Bean[] beanArray = descs;
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                Bean desc = beanArray[n2];
                try {
                    String id = (String)desc.getField("id");
                    Item i = this.items.get(id);
                    if (i == null) {
                        this.create(desc);
                        break block13;
                    }
                    if (desc.equalContents((Object)i.desc)) break block13;
                    Datatype format = (Datatype)desc.getField("format");
                    if (!i.format.equals((Object)format)) {
                        throw new HistoryException("Format conversion is not supported");
                    }
                    try {
                        byte[] data = desc.serialize();
                        i.desc = (Bean)desc.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        i.desc.deserialize(data);
                    }
                    catch (IOException e) {
                        throw new HistoryException(e);
                    }
                    catch (InstantiationException e) {
                        throw new HistoryException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new HistoryException(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new HistoryException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new HistoryException(e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new HistoryException(e);
                    }
                    catch (SecurityException e) {
                        throw new HistoryException(e);
                    }
                    this.cachedItemManager = null;
                }
                catch (BindingException e) {
                    throw new HistoryException(e);
                }
            }
            ++n2;
        }
    }

    @Override
    public Bean getItem(String itemId) throws HistoryException {
        Item i = this.items.get(itemId);
        if (i == null) {
            throw new HistoryException(itemId + " does not exist");
        }
        return i.desc;
    }

    @Override
    public Bean[] getItems() throws HistoryException {
        Bean[] result = new Bean[this.items.size()];
        int ix = 0;
        for (Item i : this.items.values()) {
            result[ix++] = i.desc;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemManager getItemManager() throws HistoryException {
        MemoryHistory memoryHistory = this;
        synchronized (memoryHistory) {
            ItemManager im = this.cachedItemManager;
            if (im != null) {
                return im;
            }
            im = this.cachedItemManager = new ItemManager(this.getItems());
            return im;
        }
    }

    @Override
    public synchronized void close() {
        this.cachedItemManager = null;
    }

    @Override
    public StreamAccessor openStream(String itemId, String mode) throws HistoryException {
        Item i = this.items.get(itemId);
        if (i == null) {
            throw new HistoryException(itemId + " does not exist");
        }
        return i.stream;
    }

    @Override
    public synchronized boolean exists(String itemId) throws HistoryException {
        return this.items.containsKey(itemId);
    }

    static class Item {
        JavaArray stream;
        Bean desc;
        Datatype format;

        Item() {
        }
    }
}

