/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.impl;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.file.FileArrayAccessor;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.databoard.util.URIUtil;
import org.simantics.databoard.util.binary.BinaryMemory;
import org.simantics.databoard.util.binary.ByteBufferWriteable;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.ItemManager;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHistory
implements HistoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileHistory.class);
    private static ArrayType INDEX_TYPE = Bindings.LONG_ARRAY.type();
    private static final boolean PROFILE = false;
    private static final boolean DEBUG = false;
    private static FilenameFilter txtFilter = (dir, name) -> name.toLowerCase().endsWith(".txt");
    private final File workarea;
    private final Path workareaPath;
    public boolean asyncUsage = true;
    private boolean itemCachingEnabled = false;
    private volatile transient Bean[] cachedItems;
    private volatile transient ItemManager cachedItemManager;
    private transient WatchService watcher;
    private transient WatchKey watchKey;
    private transient PollWatcher poller;
    private static final WatchEvent.Kind<?>[] WATCH_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    private static final WatchEvent.Modifier[] WATCH_MODIFIERS = new WatchEvent.Modifier[0];
    private static ScheduledExecutorService POLLER;

    public FileHistory(File workarea) {
        this.workarea = workarea;
        this.workareaPath = workarea.toPath();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("new FileHistory({})", (Object)System.identityHashCode(this), (Object)new Exception("trace"));
        }
    }

    public FileHistory itemCaching(boolean b) {
        this.itemCachingEnabled = b;
        return this;
    }

    public File getWorkarea() {
        return this.workarea;
    }

    @Override
    public void create(Bean ... items) throws HistoryException {
        boolean changed = false;
        try {
            try {
                Bean[] beanArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Bean item = beanArray[n2];
                    this.writeMetadata(item);
                    String id = (String)item.getField("id");
                    File dataFile = this.toDataFile(id);
                    dataFile.createNewFile();
                    Datatype type = (Datatype)item.getField("format");
                    if (this.isVariableWidth(type)) {
                        File indexFile = this.toIndexFile(id);
                        indexFile.createNewFile();
                    }
                    changed = true;
                    ++n2;
                }
            }
            catch (BindingException e) {
                throw new HistoryException(e);
            }
            catch (IOException e) {
                throw new HistoryException(e);
            }
        }
        finally {
            if (changed) {
                this.invalidateCaches();
            }
        }
    }

    @Override
    public void delete(String ... itemIds) throws HistoryException {
        boolean changed = false;
        try {
            String[] stringArray = itemIds;
            int n = itemIds.length;
            int n2 = 0;
            while (n2 < n) {
                String itemId = stringArray[n2];
                File meta = this.toMetaFile(itemId);
                File data = this.toDataFile(itemId);
                File index = this.toIndexFile(itemId);
                if (meta.exists()) {
                    if (!meta.delete()) {
                        throw new HistoryException("Failed to delete " + String.valueOf(meta));
                    }
                    changed = true;
                }
                if (data.exists()) {
                    if (!data.delete()) {
                        throw new HistoryException("Failed to delete " + String.valueOf(data));
                    }
                    changed = true;
                }
                if (index.exists() && index.delete()) {
                    changed = true;
                }
                ++n2;
            }
        }
        finally {
            if (changed) {
                this.invalidateCaches();
            }
        }
    }

    @Override
    public void modify(Bean ... items) throws HistoryException {
        boolean metadataChanged = false;
        boolean debugEnabled = LOGGER.isDebugEnabled();
        try {
            try {
                Bean[] beanArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Bean item = beanArray[n2];
                    String id = (String)item.getField("id");
                    File metaFile = this.toMetaFile(id);
                    if (!metaFile.exists()) {
                        this.create(item);
                    } else {
                        Bean oldItem = this.getItem(id);
                        File dataFile = this.toDataFile(id);
                        if (dataFile.exists()) {
                            boolean enabled = item.hasField("enabled") ? (Boolean)item.getFieldUnchecked("enabled") : true;
                            Datatype oldFormat = (Datatype)oldItem.getField("format");
                            Datatype newFormat = (Datatype)item.getField("format");
                            Datatype unitStrippedOldFormat = FileHistory.stripUnitAnnotations(oldFormat);
                            Datatype unitStrippedNewFormat = FileHistory.stripUnitAnnotations(newFormat);
                            if (enabled && !unitStrippedOldFormat.equals((Object)unitStrippedNewFormat)) {
                                try {
                                    Binding oldBinding = Bindings.getBeanBinding((Datatype)unitStrippedOldFormat);
                                    Binding newBinding = Bindings.getBeanBinding((Datatype)unitStrippedNewFormat);
                                    Serializer oldS = Bindings.getSerializer((Binding)oldBinding);
                                    Serializer newS = Bindings.getSerializer((Binding)newBinding);
                                    if (oldS.getConstantSize() == null || newS.getConstantSize() == null || oldS.getConstantSize() != newS.getConstantSize()) {
                                        throw new HistoryException("Changing of file format is not supported to: " + String.valueOf(dataFile));
                                    }
                                    Adapter adapter = Bindings.getAdapter((Binding)oldBinding, (Binding)newBinding);
                                    Object oldSample = oldBinding.createDefault();
                                    Object newSample = newBinding.createDefault();
                                    try (StreamAccessor sa = this.openStream(id, "rw");){
                                        int c = sa.size();
                                        int i = 0;
                                        while (i < c) {
                                            sa.get(i, oldBinding, oldSample);
                                            newSample = adapter.adapt(oldSample);
                                            sa.set(i, newBinding, newSample);
                                            ++i;
                                        }
                                    }
                                }
                                catch (AdapterConstructionException adapterConstructionException) {
                                    throw new HistoryException("Changing of file format is not supported to: " + id);
                                }
                                catch (SerializerConstructionException serializerConstructionException) {
                                    throw new HistoryException("Changing of file format is not supported to: " + id);
                                }
                                catch (AccessorException accessorException) {
                                    throw new HistoryException("Changing of file format failed to: " + id);
                                }
                                catch (AdaptException adaptException) {
                                    throw new HistoryException("Changing of file format failed to: " + id);
                                }
                            }
                        } else {
                            dataFile.createNewFile();
                        }
                        if (!FileHistory.equalsWithoutState(item, oldItem)) {
                            this.writeMetadata(item);
                            metadataChanged = true;
                        }
                    }
                    ++n2;
                }
            }
            catch (BindingException e) {
                throw new HistoryException(e);
            }
            catch (IOException e) {
                throw new HistoryException(e);
            }
        }
        finally {
            if (metadataChanged) {
                this.invalidateCaches();
            }
        }
    }

    @Override
    public Bean getItem(String itemId) throws HistoryException {
        return this.getItem(this.toMetaFile(itemId));
    }

    void writeMetadata(Bean item) throws HistoryException {
        try {
            String id = (String)item.getField("id");
            String idEnc = URIUtil.encodeURI((String)id);
            File metaFile = new File(this.workarea, idEnc + ".txt");
            Serializer typeSerializer = Bindings.getSerializer((Binding)Bindings.getBindingUnchecked(Datatype.class));
            Serializer beanSerializer = Bindings.getSerializer((Binding)item.getBinding());
            int size = typeSerializer.getSize((Object)item.getBinding().type()) + beanSerializer.getSize((Object)item);
            byte[] data = new byte[size];
            ByteBufferWriteable out = new ByteBufferWriteable(ByteBuffer.wrap(data));
            if (metaFile.exists() && this.asyncUsage) {
                File tmpFile = new File(this.workarea, idEnc + ".tmp");
                File tmp2File = new File(this.workarea, idEnc + ".tmp2");
                tmpFile.delete();
                typeSerializer.serialize((DataOutput)out, (Object)item.getBinding().type());
                beanSerializer.serialize((DataOutput)out, (Object)item);
                FileUtils.writeFile((File)tmpFile, (byte[])data);
                metaFile.renameTo(tmp2File);
                tmpFile.renameTo(metaFile);
                tmp2File.delete();
            } else {
                typeSerializer.serialize((DataOutput)out, (Object)item.getBinding().type());
                beanSerializer.serialize((DataOutput)out, (Object)item);
                FileUtils.writeFile((File)metaFile, (byte[])data);
            }
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
        catch (IOException e) {
            throw new HistoryException(e);
        }
        catch (SerializerConstructionException e) {
            throw new HistoryException(e);
        }
    }

    Bean getItem(File file) throws HistoryException {
        try {
            byte[] data = FileUtils.readFile((File)file);
            BinaryMemory in = new BinaryMemory(data);
            Serializer typeSerializer = Bindings.getSerializer((Binding)Bindings.getBindingUnchecked(Datatype.class));
            Datatype type = (Datatype)typeSerializer.deserialize((DataInput)in);
            Binding beanBinding = Bindings.getBeanBinding((Datatype)type);
            Serializer s = Bindings.getSerializer((Binding)beanBinding);
            Bean bean = (Bean)s.deserialize((DataInput)in);
            return bean;
        }
        catch (BufferUnderflowException e) {
            throw new HistoryException(e);
        }
        catch (IOException e) {
            throw new HistoryException(e);
        }
        catch (RuntimeBindingConstructionException e) {
            throw new HistoryException(e);
        }
        catch (SerializerConstructionException e) {
            throw new HistoryException(e);
        }
    }

    File toMetaFile(String itemId) {
        String name = URIUtil.encodeURI((String)itemId) + ".txt";
        File f = new File(this.workarea, name);
        return f;
    }

    File toDataFile(String itemId) {
        String name = URIUtil.encodeURI((String)itemId) + ".data";
        File f = new File(this.workarea, name);
        return f;
    }

    File toIndexFile(String itemId) {
        String name = URIUtil.encodeURI((String)itemId) + ".index";
        File f = new File(this.workarea, name);
        return f;
    }

    boolean isVariableWidth(Datatype type) throws HistoryException {
        try {
            Binding beanBinding = Bindings.getBeanBinding((Datatype)type);
            Serializer s = Bindings.getSerializer((Binding)beanBinding);
            return s.getConstantSize() == null;
        }
        catch (SerializerConstructionException e) {
            throw new HistoryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bean[] getItems() throws HistoryException {
        boolean trace = LOGGER.isTraceEnabled();
        FileHistory fileHistory = this;
        synchronized (fileHistory) {
            Bean[] ret;
            Bean[] c;
            if (this.itemCachingEnabled && (c = this.cachedItems) != null) {
                if (trace) {
                    LOGGER.trace("{} - {}: getItems(): return cached {}", new Object[]{Thread.currentThread(), this, Arrays.toString(this.cachedItems)});
                }
                return c;
            }
            if (trace) {
                LOGGER.trace("{} - {}: getItems(): construct result", (Object)Thread.currentThread(), (Object)this);
            }
            ArrayList<Bean> result = new ArrayList<Bean>();
            File[] files = this.workarea.listFiles(txtFilter);
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    result.add(this.getItem(file));
                    ++n2;
                }
            }
            if ((ret = result.toArray(new Bean[result.size()])).length > 0 && this.itemCachingEnabled && this.startMetadataWatching()) {
                this.cachedItems = ret;
                if (trace) {
                    LOGGER.trace("{} - {}: getItems(): caching items {}", new Object[]{Thread.currentThread(), this, Arrays.toString(this.cachedItems)});
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemManager getItemManager() throws HistoryException {
        boolean trace = LOGGER.isTraceEnabled();
        FileHistory fileHistory = this;
        synchronized (fileHistory) {
            ItemManager im;
            if (this.itemCachingEnabled && (im = this.cachedItemManager) != null) {
                if (trace) {
                    LOGGER.trace("{} - {}: getItemManager(): return cached: {}", new Object[]{Thread.currentThread(), this, this.cachedItemManager});
                }
                return im;
            }
            if (trace) {
                LOGGER.trace("{} - {}: getItemManager(): constructing new item manager", (Object)Thread.currentThread(), (Object)this);
            }
            im = new ItemManager(this.getItems());
            if (this.itemCachingEnabled) {
                if (trace) {
                    LOGGER.trace("{} - {}: getItemManager(): constructed new cached item manager: {}", new Object[]{Thread.currentThread(), this, im});
                }
                this.cachedItemManager = im;
            } else if (trace) {
                LOGGER.trace("{} - {}: getItemManager(): constructing new item manager", (Object)Thread.currentThread(), (Object)this);
            }
            return im;
        }
    }

    private synchronized void stopMetadataWatching() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{} - {}: stop metadata watching: {} {}", new Object[]{Thread.currentThread(), this, this.workareaPath, this.watcher});
        }
        if (this.poller != null) {
            this.poller.dispose();
            this.poller = null;
        }
        if (this.watchKey != null) {
            this.watchKey.cancel();
            this.watchKey = null;
        }
        if (this.watcher != null) {
            FileUtils.uncheckedClose((Closeable)this.watcher);
            this.watcher = null;
        }
    }

    private synchronized boolean startMetadataWatching() {
        try {
            this.stopMetadataWatching();
            this.watcher = this.workareaPath.getFileSystem().newWatchService();
            this.watchKey = this.workareaPath.register(this.watcher, WATCH_KINDS, WATCH_MODIFIERS);
            this.poller = new PollWatcher();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("{} - {}: start metadata watching: {} {}", new Object[]{Thread.currentThread(), this, this.workareaPath, this.watcher});
            }
            FileHistory.getPollingExecutor().execute(this.poller);
            return true;
        }
        catch (IOException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("{} - {}: not starting metadata watching for {}", new Object[]{Thread.currentThread(), this, this.workareaPath, e});
            }
            return false;
        }
    }

    private synchronized void invalidateCaches() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}: invalidateCaches: {} {}", new Object[]{this, this.cachedItems, this.cachedItemManager});
        }
        this.stopMetadataWatching();
        this.cachedItems = null;
        this.cachedItemManager = null;
    }

    @Override
    public synchronized void close() {
        LOGGER.trace("{}: close", (Object)this);
        this.invalidateCaches();
    }

    @Override
    public StreamAccessor openStream(String itemId, String mode) throws HistoryException {
        try {
            Bean bean = this.getItem(itemId);
            Datatype format = (Datatype)bean.getField("format");
            ArrayType arrayType = new ArrayType(format);
            File dataFile = this.toDataFile(itemId);
            if (this.isVariableWidth(format)) {
                File indexFile = this.toIndexFile(itemId);
                FileArrayAccessor index = Accessors.openStream((File)indexFile, (ArrayType)INDEX_TYPE, (String)mode);
                return (StreamAccessor)Accessors.openStream((File)dataFile, (ArrayType)arrayType, (String)mode, (ArrayAccessor)index);
            }
            return (StreamAccessor)Accessors.openStream((File)dataFile, (ArrayType)arrayType, (String)mode);
        }
        catch (AccessorConstructionException e) {
            throw new HistoryException(e);
        }
        catch (BindingException e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public boolean exists(String itemId) throws HistoryException {
        return this.toMetaFile(itemId).exists();
    }

    public int hashCode() {
        return this.workarea.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileHistory)) {
            return false;
        }
        FileHistory other = (FileHistory)obj;
        return other.workarea.equals(this.workarea);
    }

    public String toString() {
        return "FileHistory(" + System.identityHashCode(this) + "): " + String.valueOf(this.workarea);
    }

    private static boolean equalsWithoutState(Bean i1, Bean i2) {
        Component[] components1 = i1.getBinding().type().getComponents();
        Component[] components2 = i2.getBinding().type().getComponents();
        int components = Math.min(components1.length, components2.length);
        int c = 0;
        while (c < components) {
            Object o1 = i1.getFieldUnchecked(c);
            Object o2 = i2.getFieldUnchecked(c);
            if ((!"collectorState".equals(components1[c].name) || o1 != null && o2 != null) && !ObjectUtils.objectEquals((Object)o1, (Object)o2)) {
                return false;
            }
            ++c;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static Datatype stripUnitAnnotations(Datatype datatype) {
        Datatype datatype2 = datatype;
        if (datatype2 instanceof NumberType) {
            NumberType nt;
            NumberType numberType = (NumberType)datatype2;
            NumberType cfr_ignored_0 = (NumberType)datatype2;
            if (nt.getUnit() != null) {
                Binding dtb = Bindings.getBindingUnchecked(Datatype.class);
                nt = (NumberType)Bindings.cloneUnchecked((Object)datatype, (Binding)dtb, (Binding)dtb);
                datatype = nt;
                nt.setUnit(null);
            }
        } else {
            Datatype datatype3 = datatype;
            if (datatype3 instanceof ArrayType) {
                ArrayType at;
                ArrayType dtb = (ArrayType)datatype3;
                ArrayType cfr_ignored_1 = (ArrayType)datatype3;
                Datatype ct = at.componentType();
                Datatype component = FileHistory.stripUnitAnnotations(ct);
                if (component != ct) {
                    Binding dtb2 = Bindings.getBindingUnchecked(Datatype.class);
                    at = (ArrayType)Bindings.cloneUnchecked((Object)datatype, (Binding)dtb2, (Binding)dtb2);
                    datatype = at;
                    at.setComponentType(component);
                }
            } else {
                Datatype datatype4 = datatype;
                if (datatype4 instanceof RecordType) {
                    void rt;
                    RecordType ct = (RecordType)datatype4;
                    RecordType cfr_ignored_2 = (RecordType)datatype4;
                    int componentCount = rt.getComponentCount();
                    Component[] newComponents = new Component[componentCount];
                    int i = 0;
                    while (i < componentCount) {
                        Component c = rt.getComponent(i);
                        Datatype ct2 = c.type;
                        Datatype sct = FileHistory.stripUnitAnnotations(ct2);
                        newComponents[i] = new Component(c.name, sct);
                        ++i;
                    }
                    return new RecordType(rt.isReferable(), newComponents);
                }
            }
        }
        return datatype;
    }

    public static synchronized ScheduledExecutorService getPollingExecutor() {
        if (POLLER == null) {
            final ThreadGroup tg = new ThreadGroup("FileHistory");
            final AtomicInteger counter = new AtomicInteger(0);
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(tg, r, "FileHistory-Metadata-Poller-" + counter.incrementAndGet());
                    if (!t.isDaemon()) {
                        t.setDaemon(true);
                    }
                    if (t.getPriority() != 5) {
                        t.setPriority(5);
                    }
                    return t;
                }
            };
            POLLER = new ScheduledThreadPoolExecutor(0, tf);
        }
        return POLLER;
    }

    class PollWatcher
    implements Runnable {
        private boolean running = true;

        PollWatcher() {
        }

        @Override
        public void run() {
            LOGGER.trace("{}: PollWatcher thread started", (Object)FileHistory.this);
            try {
                this.run0();
            }
            finally {
                LOGGER.trace("{}: PollWatcher thread ends", (Object)FileHistory.this);
            }
        }

        private void run0() {
            while (this.running) {
                try {
                    WatchKey wk = FileHistory.this.watcher.poll(100L, TimeUnit.MILLISECONDS);
                    if (!this.running) {
                        return;
                    }
                    if (wk == null) continue;
                    for (WatchEvent<?> event : wk.pollEvents()) {
                        String lcfn;
                        Path fn;
                        WatchEvent.Kind<?> kind = event.kind();
                        if (!this.running) {
                            return;
                        }
                        WatchEvent<?> evt = event;
                        Path name = (Path)evt.context();
                        if (name == null || (fn = name.getFileName()) == null || !(lcfn = fn.toString().toLowerCase()).endsWith(".txt") || kind != StandardWatchEventKinds.ENTRY_CREATE && kind != StandardWatchEventKinds.ENTRY_MODIFY && kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                        LOGGER.trace("{} metadata event for {}: {}, invalidating caches", new Object[]{FileHistory.this, name, kind});
                        this.invalidate();
                        this.dispose();
                        return;
                    }
                    if (wk.reset()) continue;
                    LOGGER.trace("{}: watchkey is no longer valid, invalidating caches", (Object)FileHistory.this);
                    this.invalidate();
                    this.dispose();
                    return;
                }
                catch (InterruptedException e) {
                    LOGGER.debug("PollWatcher interrupted", (Throwable)e);
                }
            }
        }

        private void invalidate() {
            FileHistory.this.invalidateCaches();
        }

        public void dispose() {
            this.running = false;
        }
    }
}

