/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.history.util;

import java.util.Iterator;

import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.ArrayType;

/**
 * This class binds median class to as an array type
 *  
 */
public class MedianBinding extends ArrayBinding {

	public MedianBinding(Binding componentBinding) {
		this(new ArrayType(componentBinding.type()), componentBinding);
	}
	
	public MedianBinding(ArrayType type, Binding componentBinding) {
		super(type, componentBinding);
		if (type==null) throw new IllegalArgumentException("null arg");
		this.type = type;
	}
		
	@Override
	public Object create() {
		return new Median<Object>( componentBinding );
	}

	@Override
	public Object create(int length, Iterator<Object> it) throws BindingException {
		Median<Object> result = new Median<Object>( length, componentBinding );
		while (it.hasNext()) result.add(it.next());		
		return result;
	}

	@Override
	public Object create(Object[] array) throws BindingException {
		Median<Object> result = new Median<Object>( array.length, componentBinding );
		for (int i=0; i<array.length; i++) result.add( array[i] );
		return result;
	}

	@Override
	public void add(Object array, int index, Object element) throws BindingException, IndexOutOfBoundsException {
		@SuppressWarnings("unchecked")
		Median<Object> median = (Median<Object>) array;
		median.add(element);
	}

	@Override
	public void remove(Object array, int index, int count) throws BindingException {
		if (index<0 || index+count>=size(array)) 
			throw new BindingException("Indx out of bounds");
		
		@SuppressWarnings("unchecked")
		Median<Object> median = (Median<Object>) array;
		
		if (index<median.lower.size()) {
			Iterator<Object> it = median.lower.iterator();
			for ( int i=0; i<=index; i++ ) it.next();
			it.remove();
			return;
		}
		index -= median.lower.size();
		if (median.median != null) index--;
		if (index==-1) {
	        if (median.upper.size() >= median.lower.size()) {
	            median.median = median.upper.remove();
	        } else {
	            median.median = median.lower.remove();
	        }			
	        return;
		}
		if (index<median.upper.size()) {
			Iterator<Object> it = median.upper.iterator();
			for ( int i=0; i<=index; i++ ) it.next();
			it.remove();
			return;
		}				
		
	}

	@Override
	public Object get(Object array, int index) throws BindingException {
		@SuppressWarnings("unchecked")
		Median<Object> median = (Median<Object>) array;
		if (index<0) throw new BindingException("Index out of bounds");
		if (index<median.lower.size()) {
			Object result = null;
			Iterator<Object> it = median.lower.iterator();
			for ( int i=0; i<=index; i++ ) result = it.next();
			return result;
		}
		index -= median.lower.size();
		if (median.median != null) index--;
		if (index==-1) {
			return median.median;
		}
		if (index<median.upper.size()) {
			Object result = null;
			Iterator<Object> it = median.upper.iterator();
			for ( int i=0; i<=index; i++ ) result = it.next();
			return result;
		}				
		return null;
	}

	@Override
	public void getAll(Object array, Object[] result) throws BindingException {
		int c = size( array );
		if (result.length<c) throw new BindingException("Array too small");

		int index = 0;
		@SuppressWarnings("unchecked")
		Median<Object> median = (Median<Object>) array;

		Iterator<Object> it = median.lower.iterator();
		while (it.hasNext()) result[index++] = it.next();
		if (median.getMedian() != null) result[index++] = median.getMedian();
		it = median.upper.iterator();
		while (it.hasNext()) result[index++] = it.next();
	}

	@Override
	public void set(Object array, int index, Object value) throws BindingException {
		remove(array, index);
		add(array, value);
	}

	@Override
	public void setSize(Object array, int newSize) throws BindingException {
		int size = size(array);
		if (size<newSize) newSize = size;
		remove( array, size-newSize, newSize);
	}

	@Override
	public int size(Object array) throws BindingException {
		@SuppressWarnings("unchecked")
		Median<Object> median = (Median<Object>) array;
		int count = 0;
		if (median.median != null) count++;
		count += median.lower.size();
		count += median.upper.size();
		return count;
	}

	@Override
	public boolean isInstance(Object obj) {
		return obj instanceof Median;
	}	

	@Override
	public boolean isResizable() {
		return true;
	}
	
}


