/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.history;

import org.simantics.databoard.annotations.Identifier;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.history.util.subscription.SamplingFormat;

/**
 * (Utility class) Item format for both HistoryManager and Collector.
 * 
 * SubscriptionItem describes how to read one Datasource Item and how to write to one History Item.
 * 
 * @author toni.kalajainen
 */
public class HistoryAndCollectorItem extends Bean.Id {
	
	/** A reference to an item in Datasource */
	public String variableId;
	
	/** History item reference */
	public @Identifier String id;
	
	/** 
	 * Describes the format of the packed sample. The sample must be a record.
	 * The record must have any combination of the following named fields.
	 * The field types must one of: byte, integer, long, float, double.
	 * 
	 * time, endTime, value - are mandatory fields.
	 * 
	 *  time      -  Region start time, the time of the 1st included sample
	 *  endTime   -  Region end time, the time of the last included sample
	 *  
	 *  value     -  First value in the region
	 *  lastValue -  Last value in the region
	 *  avg       -  Average value of all included samples
	 *  median    -  Median value of all samples in the region
	 *  min       -  Lowest value in the region
	 *  max       -  Highest value in the region
	 *  
	 *  quality   -  0 = Good, -1 = No value
	 *  count     -  The number of included samples in the region
	 *  
	 * See {@link SamplingFormat} for example formats. 
	 */
	public Datatype format;
			
	// Subscription parameters
	public double deadband = Double.NaN;
	public double interval = Double.NaN;
	public double gain = 1.0;
	public double bias = 0.0;
	public boolean enabled = true;
	
}
