/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.simantics.graphviz.IAttributeContainer;

public class AbstractAttributeContainer
implements IAttributeContainer {
    Map<String, String> attributes = new HashMap<String, String>();

    @Override
    public void set(String key, String value) {
        this.attributes.put(key, value);
    }

    @Override
    public String get(String key) {
        return this.attributes.get(key);
    }

    protected void writeAttributes(PrintStream s) {
        if (this.attributes.isEmpty()) {
            s.println(";");
            return;
        }
        s.print(" [");
        boolean first = true;
        for (Map.Entry<String, String> ent : this.attributes.entrySet()) {
            String key = ent.getKey();
            String value = ent.getValue();
            if (first) {
                first = false;
            } else {
                s.print(' ');
            }
            s.print(key);
            if (!value.isEmpty() && value.charAt(0) == '<' && value.charAt(value.length() - 1) == '>') {
                s.print('=');
                s.print(value);
                continue;
            }
            s.print("=\"");
            s.print(AbstractAttributeContainer.escape(value));
            s.print('\"');
        }
        s.println("];");
    }

    static String escape(String str) {
        str = str.replace("\"", "\\\"");
        return str;
    }
}

