/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz.internal.xdot;

import java.awt.BasicStroke;
import java.awt.Graphics2D;

public class SetStyle implements DrawCommand {

    private static final BasicStroke SOLID = new BasicStroke(1f, BasicStroke.CAP_SQUARE, BasicStroke.JOIN_MITER, 10.0f, null, 0.0f);
    private static final BasicStroke DASHED = new BasicStroke(1f, BasicStroke.CAP_SQUARE, BasicStroke.JOIN_MITER, 10.0f, new float[] {5f, 5f}, 0.0f);
    private static final BasicStroke DOTTED = new BasicStroke(1f, BasicStroke.CAP_SQUARE, BasicStroke.JOIN_MITER, 10.0f, new float[] {0f, 2f}, 0.0f);
    
    String styleName;
    
	public SetStyle(String styleName) {
	    this.styleName = styleName;
	}

	@Override
	public void draw(Graphics2D g) {
		if(styleName.equals("solid"))
		    g.setStroke(SOLID);
		else if(styleName.equals("dashed"))
		    g.setStroke(DASHED);
		else if(styleName.equals("dotted"))
            g.setStroke(DOTTED);
		else if(styleName.startsWith("setlinewidth(")) {
		    double w = Double.parseDouble(styleName.substring(13, styleName.length()-1));
		    g.setStroke(new BasicStroke((float)w, BasicStroke.CAP_SQUARE, BasicStroke.JOIN_MITER, 10.0f, ((BasicStroke)g.getStroke()).getDashArray(), 0.0f));
		}
		else
		    System.out.println("Unknown style: " + styleName);
	}

}
