/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/**
 * A hierarchial part of a graph.  
 * 
 * @author Hannu Niemist
 */
public class Subgraph extends AbstractIdentifiableGraphPart implements IGraph {
    Collection<IGraphPart> parts = new ArrayList<IGraphPart>();
    int curId = 0;

    public Subgraph(IGraph parent) {
        super(parent);
    }

    @Override
    public void addPart(IGraphPart part) {
        parts.add(part);        
    }

    @Override
    public String newId() {
        return getId() + "_" + (++curId);
    }

    @Override
    public Collection<IGraphPart> getParts() {
        return Collections.unmodifiableCollection(parts);
    }

    @Override
    public void write(PrintStream s) {
        s.print("subgraph ");
        s.print(id);
        s.println(" {");
        s.print("graph");
        writeAttributes(s);
        for(IGraphPart part : parts)
            part.write(s);
        s.println("};");        
    }

}
