/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.store;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TObjectIntProcedure;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.PathChild;
import org.simantics.graph.query.PathRoot;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Root;
import org.simantics.graph.store.IStore;
import org.simantics.graph.store.IndexMappingUtils;

public class IdentityStore
implements IStore {
    private static int[] EMPTY_INT_ARRAY = new int[0];
    TObjectIntHashMap<String> roots = new TObjectIntHashMap();
    TIntObjectHashMap<String> invRoots = new TIntObjectHashMap();
    TIntObjectHashMap<THashMap<String, ConsistsOf>> parentMap = new TIntObjectHashMap();
    TIntObjectHashMap<ConsistsOf> childMap = new TIntObjectHashMap();
    TIntHashSet newResources = new TIntHashSet();
    int resourceCount = 0;
    TIntIntHashMap unifications = new TIntIntHashMap();
    TIntHashSet collisions = new TIntHashSet();

    public int newResource() {
        return this.resourceCount++;
    }

    public boolean markNew(int resource) {
        return this.newResources.add(resource);
    }

    public int[] getNewResources() {
        return this.newResources.toArray();
    }

    public int getResourceCount() {
        return this.resourceCount;
    }

    public void setResourceCount(int newCount) {
        this.resourceCount = newCount;
    }

    public void defineRoot(String name, int root) {
        if (this.roots.contains((Object)name)) {
            this.unify(root, this.roots.get((Object)name));
        }
        this.roots.put((Object)name, root);
        this.invRoots.put(root, (Object)name);
    }

    public void defineChild(int parent, String name, int child) {
        ConsistsOf consistsOf;
        ConsistsOf oldC;
        THashMap map = (THashMap)this.parentMap.get(parent);
        if (map == null) {
            map = new THashMap();
            this.parentMap.put(parent, (Object)map);
        }
        if ((oldC = (ConsistsOf)map.put((Object)name, (Object)(consistsOf = new ConsistsOf(parent, name, child)))) != null) {
            this.unify(child, oldC.child);
        }
        this.childMap.put(child, (Object)consistsOf);
    }

    public boolean hasChild(int parent, String name) {
        THashMap map = (THashMap)this.parentMap.get(parent);
        if (map == null) {
            return false;
        }
        return map.contains((Object)name);
    }

    public int getChild(int parent, String name) {
        THashMap map = (THashMap)this.parentMap.get(parent);
        if (map == null) {
            map = new THashMap();
            this.parentMap.put(parent, (Object)map);
        } else if (map.contains((Object)name)) {
            return ((ConsistsOf)map.get((Object)name)).child;
        }
        int child = this.newResource();
        ConsistsOf consistsOf = new ConsistsOf(parent, name, child);
        map.put((Object)name, (Object)consistsOf);
        this.childMap.put(child, (Object)consistsOf);
        return child;
    }

    public int getChildIfExists(int parent, String name) {
        THashMap map = (THashMap)this.parentMap.get(parent);
        if (map != null && map.contains((Object)name)) {
            return ((ConsistsOf)map.get((Object)name)).child;
        }
        return -1;
    }

    public int getRoot(String uri) {
        if (this.roots.contains((Object)uri)) {
            return this.roots.get((Object)uri);
        }
        int root = this.newResource();
        this.roots.put((Object)uri, root);
        this.invRoots.put(root, (Object)uri);
        return root;
    }

    public int getRootIfExists(String uri) {
        if (this.roots.contains((Object)uri)) {
            return this.roots.get((Object)uri);
        }
        return -1;
    }

    public int[] getChildren(int id) {
        THashMap map = (THashMap)this.parentMap.get(id);
        if (map == null) {
            return EMPTY_INT_ARRAY;
        }
        final int[] result = new int[map.size()];
        map.forEachValue((TObjectProcedure)new TObjectProcedure<ConsistsOf>(){
            int i = 0;

            public boolean execute(ConsistsOf object) {
                result[this.i++] = object.child;
                return true;
            }
        });
        return result;
    }

    public THashMap<String, ConsistsOf> getChildMap(int parent) {
        return (THashMap)this.parentMap.get(parent);
    }

    private void collectIdentities(final int parent, final ArrayList<Identity> identities) {
        THashMap map = (THashMap)this.parentMap.get(parent);
        if (map != null) {
            map.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, ConsistsOf>(){

                public boolean execute(String a, ConsistsOf b) {
                    if (IdentityStore.this.newResources.contains(b.child)) {
                        identities.add(new Identity(b.child, new Internal(parent, a)));
                    } else {
                        identities.add(new Identity(b.child, new External(parent, a)));
                    }
                    IdentityStore.this.collectIdentities(b.child, identities);
                    return true;
                }
            });
        }
    }

    private void collectIdentities(final ArrayList<Identity> identities) {
        this.roots.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String a, int b) {
                identities.add(new Identity(b, new Root(a, "")));
                IdentityStore.this.collectIdentities(b, identities);
                return true;
            }
        });
    }

    @Override
    public void map(final TIntIntHashMap map) {
        this.collisions = IndexMappingUtils.map(map, this.collisions);
        this.newResources = IndexMappingUtils.map(map, this.newResources);
        IndexMappingUtils.map(map, this.roots);
        this.invRoots = IndexMappingUtils.map(map, this.invRoots, this.collisions);
        final ArrayList consistsOfs = new ArrayList(this.childMap.size());
        this.childMap.forEachValue((TObjectProcedure)new TObjectProcedure<ConsistsOf>(){

            public boolean execute(ConsistsOf c) {
                if (map.contains(c.parent)) {
                    c.parent = map.get(c.parent);
                }
                if (map.contains(c.child)) {
                    c.child = map.get(c.child);
                }
                consistsOfs.add(c);
                return true;
            }
        });
        this.childMap.clear();
        this.parentMap.clear();
        assert (this.unifications.isEmpty());
        for (ConsistsOf c : consistsOfs) {
            THashMap m = (THashMap)this.parentMap.get(c.parent);
            if (m == null) {
                m = new THashMap();
                this.parentMap.put(c.parent, (Object)m);
            }
            ConsistsOf oldC = (ConsistsOf)m.put((Object)c.name, (Object)c);
            ConsistsOf childC = (ConsistsOf)this.childMap.put(c.child, (Object)c);
            if (!(childC == null || childC.parent == c.parent && childC.name.equals(c.name))) {
                this.collisions.add(c.child);
            }
            if (oldC == null) continue;
            this.unify(oldC.child, c.child);
        }
    }

    public int pathToId(Path path) {
        if (path instanceof PathChild) {
            PathChild child = (PathChild)path;
            int parent = this.pathToId(child.parent);
            if (parent < 0) {
                return -1;
            }
            return this.getChildIfExists(parent, child.name);
        }
        if (path instanceof PathRoot) {
            return this.getRootIfExists(((PathRoot)path).name);
        }
        throw new IllegalArgumentException();
    }

    public int createPathToId(Path path) {
        if (path instanceof PathChild) {
            PathChild child = (PathChild)path;
            return this.getChild(this.createPathToId(child.parent), child.name);
        }
        if (path instanceof PathRoot) {
            return this.getRoot(((PathRoot)path).name);
        }
        throw new IllegalArgumentException();
    }

    public Path idToPath(int id) {
        ConsistsOf consistsOf = (ConsistsOf)this.childMap.get(id);
        if (consistsOf == null) {
            String root = (String)this.invRoots.get(id);
            if (root == null) {
                return null;
            }
            return new PathRoot(root);
        }
        Path parentPath = this.idToPath(consistsOf.parent);
        if (parentPath == null) {
            return null;
        }
        return new PathChild(consistsOf.name, parentPath);
    }

    public boolean contains(Path path) {
        return this.pathToId(path) >= 0;
    }

    public boolean isNewResource(int id) {
        return this.newResources.contains(id);
    }

    public Identity[] toArray() {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        this.collectIdentities(identities);
        return identities.toArray(new Identity[identities.size()]);
    }

    public void collectReferences(final boolean[] set) {
        TIntProcedure proc = new TIntProcedure(){

            public boolean execute(int value) {
                set[value] = true;
                return true;
            }
        };
        this.roots.forEachValue(proc);
        this.childMap.forEach(proc);
        this.parentMap.forEach(proc);
    }

    public int removeIdentity(int id) {
        ConsistsOf c = (ConsistsOf)this.childMap.remove(id);
        if (c != null) {
            ((THashMap)this.parentMap.get(c.parent)).remove((Object)c.name);
            return c.parent;
        }
        return -1;
    }

    public boolean hasIdentity(int id) {
        return this.childMap.containsKey(id);
    }

    public void definePath(Path path, int resource) {
        if (path instanceof PathChild) {
            PathChild child = (PathChild)path;
            int parent = this.createPathToId(child.parent);
            this.defineChild(parent, child.name, resource);
        } else if (path instanceof PathRoot) {
            this.defineRoot(((PathRoot)path).name, resource);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void printChildMap() {
        System.out.println("ChildMap:");
        this.childMap.forEachValue((TObjectProcedure)new TObjectProcedure<ConsistsOf>(){

            public boolean execute(ConsistsOf c) {
                System.out.println("    " + c.child + " = " + c.parent + "." + c.name);
                return true;
            }
        });
    }

    private int canonical(int a) {
        if (this.unifications.contains(a)) {
            int b = this.unifications.get(a);
            if (this.unifications.contains(b)) {
                int c = this.canonical(b);
                this.unifications.put(a, c);
                this.unifications.put(b, c);
                return c;
            }
            return b;
        }
        return a;
    }

    public TIntIntHashMap extractUnifications() {
        int[] nArray = this.unifications.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int a = nArray[n2];
            this.canonical(a);
            ++n2;
        }
        TIntIntHashMap result = this.unifications;
        this.unifications = new TIntIntHashMap();
        return result;
    }

    public void unify(int a, int b) {
        if (a != b && (a = this.canonical(a)) != (b = this.canonical(b))) {
            this.unifications.put(a, b);
        }
    }

    public TIntHashSet getCollisions() {
        return this.collisions;
    }

    public String[] getRoots() {
        return (String[])this.roots.keys((Object[])new String[this.roots.size()]);
    }

    void findChildren(int id, final Path path, final String suffix, final Pattern pattern, final THashSet<Path> result) {
        THashMap map;
        if (pattern.matcher(suffix).matches()) {
            result.add((Object)path);
        }
        if ((map = (THashMap)this.parentMap.get(id)) != null) {
            map.forEachValue((TObjectProcedure)new TObjectProcedure<ConsistsOf>(){

                public boolean execute(ConsistsOf consistsOf) {
                    IdentityStore.this.findChildren(consistsOf.child, new PathChild(consistsOf.name, path), suffix + "/" + consistsOf.name, pattern, (THashSet<Path>)result);
                    return true;
                }
            });
        }
    }

    public int[] getUnfoundedIdentities() {
        TIntArrayList result = new TIntArrayList();
        int[] nArray = this.parentMap.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int resource = nArray[n2];
            if (!this.childMap.containsKey(resource) && !this.invRoots.containsKey(resource)) {
                result.add(resource);
            }
            ++n2;
        }
        return result.toArray();
    }

    public void forEachChild(TObjectProcedure<ConsistsOf> proc) {
        this.childMap.forEachValue(proc);
    }

    public void setIdentity(int child, int parent, String name) {
        THashMap map = (THashMap)this.parentMap.get(parent);
        if (map == null) {
            map = new THashMap();
            this.parentMap.put(parent, (Object)map);
        } else if (map.contains((Object)name)) {
            throw new IllegalStateException();
        }
        ConsistsOf consistsOf = new ConsistsOf(parent, name, child);
        map.put((Object)name, (Object)consistsOf);
        this.childMap.put(child, (Object)consistsOf);
    }

    public static class ConsistsOf {
        public int parent;
        public String name;
        public int child;

        public ConsistsOf(int parent, String name, int child) {
            this.parent = parent;
            this.name = name;
            this.child = child;
        }
    }
}

