/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.representation;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntIntProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.TLongHashSet;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.databoard.parser.DataValuePrinter;
import org.simantics.databoard.parser.PrintFormat;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphQueries;
import org.simantics.graph.representation.TransferableGraphUtils;
import org.simantics.graph.representation.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrettyPrintTG {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrettyPrintTG.class);
    private static final boolean DEBUG = false;
    int blankCounter = 0;
    int newBlankCounter = 0;
    Map<String, String> blankRewrites = new HashMap<String, String>();
    MessageDigest m;
    private final Pattern versionExtractPattern = Pattern.compile("^.*-(\\d+\\.\\d+)");
    final StringBuilder output;
    final Map<String, String> ontologies = new HashMap<String, String>(knownOntologies);
    final Set<String> referencedOntologies = new TreeSet<String>();
    private boolean ignoreIdentifiers;
    private TransferableGraphQueries query;
    TreeMap<String, ResourceInfo> orderedInfos = new TreeMap();
    TIntObjectHashMap<ResourceInfo> infos = new TIntObjectHashMap();
    DataValueRepository repo = new DataValueRepository();
    DataValuePrinter printer = new DataValuePrinter(null, this.repo);
    static Map<String, String> knownOntologies = new HashMap<String, String>();
    private THashMap<String, String> hashes = new THashMap();

    static {
        knownOntologies.put("http://www.simantics.org/Layer0-1.1", "L0");
        knownOntologies.put("http://www.simantics.org/Layer0X-1.1", "L0X");
        knownOntologies.put("http://www.simantics.org/Modeling-1.2", "MOD");
        knownOntologies.put("http://www.simantics.org/Diagram-2.2", "DIA");
        knownOntologies.put("http://www.simantics.org/Structural-1.2", "STR");
        knownOntologies.put("http://www.simantics.org/Document-1.2", "DOC");
        knownOntologies.put("http://www.simantics.org/Documentation-1.2", "DOCU");
        knownOntologies.put("http://www.simantics.org/G2D-1.1", "G2D");
        knownOntologies.put("http://www.simantics.org/SelectionView-1.2", "SEL");
        knownOntologies.put("http://www.simantics.org/Viewpoint-1.2", "VP");
        knownOntologies.put("http://www.simantics.org/Image2-1.2", "IMAGE2");
        knownOntologies.put("http://www.simantics.org/GraphFile-0.1", "GRAPHFILE");
        knownOntologies.put("http://www.simantics.org/Project-1.2", "PROJECT");
        knownOntologies.put("http://www.semantum.fi/Simupedia-1.0", "SIMUPEDIA");
        knownOntologies.put("http://www.semantum.fi/SimupediaWorkbench-1.0", "SIMUPEDIA_WORKBENCH");
    }

    public PrettyPrintTG(TransferableGraph1 tg, StringBuilder b, boolean ignoreIdentifiers) throws NoSuchAlgorithmException {
        this.output = b;
        this.m = MessageDigest.getInstance("SHA-256");
        this.ignoreIdentifiers = ignoreIdentifiers;
        this.query = new TransferableGraphQueries(tg);
    }

    public PrettyPrintTG(TransferableGraph1 tg) throws NoSuchAlgorithmException {
        this(tg, new StringBuilder(), false);
    }

    private static String tgNodeName(String name) {
        if (name.contains(" ")) {
            return "\"" + name + "\"";
        }
        return name;
    }

    private ResourceInfo recurseURI(Map<String, ResourceInfo> infos, Identity identity, String parentName, int parentId) {
        String name = parentName + "." + PrettyPrintTG.tgNodeName(TransferableGraphUtils.getName(identity));
        int identityResource = identity.resource;
        ResourceInfo info = new ResourceInfo(true, name, identityResource, parentId);
        infos.put(name, info);
        for (Identity child : this.query.getChildren(identity)) {
            this.recurseURI(infos, child, name, identityResource);
        }
        return info;
    }

    private TreeMap<String, TreeSet<Integer>> sortByPredicateUniqueStatements(int resource) {
        TreeMap<String, TreeSet<Integer>> results = new TreeMap<String, TreeSet<Integer>>();
        TIntArrayList statements = this.query.getStatements(resource);
        int i = 0;
        while (i < statements.size()) {
            int predicate = statements.get(i);
            String predicateURI = this.query.getURI(predicate);
            TreeSet<Integer> objects = results.get(predicateURI);
            if (objects == null) {
                objects = new TreeSet();
            }
            objects.add(statements.get(i + 1));
            results.put(predicateURI, objects);
            i += 2;
        }
        return results;
    }

    void discoverBlank(int resource, TIntArrayList todo) throws Exception {
        for (TreeSet<Integer> objects : this.sortByPredicateUniqueStatements(resource).values()) {
            for (int object : objects) {
                Identity objectId = this.query.getIdentity(object);
                if (objectId != null && objectId.definition instanceof External) continue;
                Value value = this.query.findValue(object);
                if (value != null) {
                    this.infos.put(object, (Object)new ResourceInfo(false, this.printValue(value), object, resource));
                    continue;
                }
                ResourceInfo existing = (ResourceInfo)this.infos.get(object);
                if (existing != null) continue;
                existing = new ResourceInfo(false, "blank" + this.blankCounter++, object, resource);
                this.infos.put(object, (Object)existing);
                todo.add(object);
            }
        }
    }

    private String makeHash(byte[] data) {
        this.m.reset();
        this.m.update(data, 0, data.length);
        return new BigInteger(1, this.m.digest()).toString(16);
    }

    void discoverOwners(ResourceInfo info) {
        PrettyPrintTG.log("Discovering owners for {}", info);
        int resource = info.resource;
        TIntArrayList statements = this.query.getStatements(resource);
        int i = 0;
        while (i < statements.size()) {
            String predicateUri;
            int predicate = statements.get(i);
            int object = statements.get(i + 1);
            ResourceInfo existing = (ResourceInfo)this.infos.get(object);
            if (existing != null && !(predicateUri = this.rewritePredicateURI(predicate)).endsWith("Inverse") && !predicateUri.endsWith("Of")) {
                existing.ownedResourcesWithPredicates.put(resource, predicate);
                existing.ownedBy.add(info);
                PrettyPrintTG.log("    {} owns {} with {}", existing, info, predicateUri);
            }
            i += 2;
        }
    }

    String printValue(Value value) throws Exception {
        StringBuilder sb = new StringBuilder();
        this.printer.setFormat(PrintFormat.SINGLE_LINE);
        this.printer.setOutput((Appendable)sb);
        Variant variant = value.value;
        this.printer.print(variant.getBinding(), variant.getValue());
        String formattedOutput = sb.toString();
        if (formattedOutput.length() > 100) {
            byte[] data = Bindings.getSerializerUnchecked((Binding)variant.getBinding()).serialize(variant.getValue());
            this.m.reset();
            this.m.update(data, 0, data.length);
            String hash = "\"" + new BigInteger(1, this.m.digest()).toString(16) + "\"";
            return hash + " // " + formattedOutput.substring(0, 100) + "..";
        }
        return formattedOutput;
    }

    public String getExternalURI(External ext) {
        String name = ext.name;
        if (name.contains(" ")) {
            name = name.replace(" ", "_").replaceAll("@", "_");
        }
        int parentId = ext.parent;
        Identity id = this.query.getIdentity(parentId);
        if (id.definition instanceof External) {
            return this.getExternalURI((External)id.definition) + "/" + URIStringUtils.escape((String)name);
        }
        if (id.definition instanceof Root) {
            Root root = (Root)id.definition;
            return "http:/" + URIStringUtils.escape((String)root.name) + "/" + URIStringUtils.escape((String)name);
        }
        return null;
    }

    public String getExternalURI(int resource) {
        Identity id = this.query.getIdentity(resource);
        if (id == null) {
            return null;
        }
        if (id.definition instanceof External) {
            External ext = (External)id.definition;
            return this.getExternalURI(ext);
        }
        return null;
    }

    String rewritePredicateURI(int predicate) {
        String uri = this.getExternalURI(predicate);
        if (uri == null) {
            ResourceInfo info = (ResourceInfo)this.infos.get(predicate);
            if (info != null) {
                return info.name;
            }
            return "_";
        }
        for (String ontology : this.ontologies.keySet()) {
            if (!uri.contains(ontology)) continue;
            String key = this.ontologies.get(ontology);
            uri = uri.replace(ontology, key);
            this.referencedOntologies.add(ontology);
        }
        uri = uri.replace("/", ".");
        return uri;
    }

    static void indent(StringBuilder output, int indent) {
        int i = 0;
        while (i < indent) {
            output.append("  ");
            ++i;
        }
    }

    String printBlank(String predicateURI2, ResourceInfo info, int indent) {
        String uri;
        if (info.hasURI) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        String infoName = info.name;
        if (infoName.startsWith("blank")) {
            infoName = this.getBlankRewrite(infoName);
        }
        if (this.ignoreIdentifiers) {
            if (!predicateURI2.contains("L0.identifier")) {
                PrettyPrintTG.indent(output, indent);
                output.append(predicateURI2 + " " + infoName + "\n");
            }
        } else {
            PrettyPrintTG.indent(output, indent);
            output.append(predicateURI2 + " " + infoName + "\n");
        }
        if (info.ownedResourcesWithPredicates.isEmpty() && (uri = this.printURI(info, false, indent, false)) != null) {
            output.append(uri);
        }
        return output.toString();
    }

    private String getBlankRewrite(String infoName) {
        Object rewrite = this.blankRewrites.get(infoName);
        if (rewrite == null) {
            rewrite = "rblank" + this.newBlankCounter++;
            this.blankRewrites.put(infoName, (String)rewrite);
        }
        return rewrite;
    }

    static long longStm(int predicate, int object) {
        return ((long)predicate & 0xFFFFFFFFL) << 32 | (long)object & 0xFFFFFFFFL;
    }

    private void addInlineStatement(Map<String, Set<String>> statements, String predicate, ResourceInfo objectInfo, int indent) {
        String uri;
        Set<String> objects = statements.get(predicate);
        if (objects == null) {
            objects = new TreeSet<String>();
            statements.put(predicate, objects);
        }
        if ((uri = this.printURI(objectInfo, false, indent + 1, true)) != null) {
            uri = uri.endsWith("\n") ? uri.substring(0, uri.length() - 2) : uri;
            objects.add(uri);
        }
        objectInfo.inlined = true;
    }

    void addStatement(Map<String, Set<String>> statements, String predicate, String object) {
        if (predicate.endsWith("Inverse")) {
            return;
        }
        Set<String> objects = statements.get(predicate);
        if (objects == null) {
            objects = new TreeSet<String>();
            statements.put(predicate, objects);
        }
        objects.add(object);
    }

    String printURI(ResourceInfo info, boolean requireURI, int indent, boolean inline) {
        Object predicateURI;
        if (requireURI && !info.hasURI) {
            return null;
        }
        if (info.inlined) {
            return null;
        }
        TreeMap<String, Set<String>> statements = new TreeMap<String, Set<String>>();
        Identity consistsOf = this.query.findExternalByURI("http://www.simantics.org/Layer0-1.1/ConsistsOf");
        TLongHashSet processed = new TLongHashSet();
        int i = 0;
        while (i < info.owned.size()) {
            int predicate = info.owned.get(i);
            int object = info.owned.get(i + 1);
            long stmId = PrettyPrintTG.longStm(predicate, object);
            processed.add(stmId);
            i += 2;
        }
        TreeMap predicateURIs = new TreeMap();
        TIntArrayList rawStatements = this.query.getStatements(info.resource);
        int i2 = 0;
        while (i2 < rawStatements.size()) {
            int object;
            int predicate = rawStatements.get(i2);
            long stmId = PrettyPrintTG.longStm(predicate, object = rawStatements.get(i2 + 1));
            if (processed.add(stmId) && consistsOf.resource != predicate) {
                predicateURI = this.rewritePredicateURI(predicate);
                ArrayList<Integer> objects = (ArrayList<Integer>)predicateURIs.get(predicateURI);
                if (objects == null) {
                    objects = new ArrayList<Integer>();
                    predicateURIs.put(predicateURI, objects);
                }
                objects.add(object);
            }
            i2 += 2;
        }
        for (Map.Entry entry : predicateURIs.entrySet()) {
            String predicateURI2 = (String)entry.getKey();
            List objects = (List)entry.getValue();
            predicateURI = objects.iterator();
            while (predicateURI.hasNext()) {
                int object = (Integer)predicateURI.next();
                ResourceInfo objectInfo = (ResourceInfo)this.infos.get(object);
                if (objectInfo == null) {
                    String objectURI = this.rewritePredicateURI(object);
                    this.addStatement(statements, predicateURI2, objectURI);
                    continue;
                }
                if (objectInfo.ownedBy.size() == 1 && objectInfo.ownedBy.contains(info)) {
                    this.addInlineStatement(statements, predicateURI2, objectInfo, indent);
                    continue;
                }
                String objectName = objectInfo.name;
                if (objectName.startsWith("blank")) {
                    objectName = this.getBlankRewrite(objectName);
                }
                this.addStatement(statements, predicateURI2, objectName);
            }
        }
        StringBuilder output = new StringBuilder();
        if (indent == 0 || inline) {
            Set inherits;
            Set subrelationOfs;
            if ("ROOT".equals(info.name)) {
                output.append("ROOT=<http:/>");
            } else if (info.aliasURI != null) {
                output.append(info.name + " = <" + info.aliasURI + ">");
            } else {
                String infoName = info.name;
                if (infoName.startsWith("blank")) {
                    infoName = this.getBlankRewrite(infoName);
                }
                output.append(inline ? "_" : infoName);
            }
            Set instanceOfs = (Set)statements.get("L0.InstanceOf");
            if (instanceOfs != null) {
                for (String instanceOf : instanceOfs) {
                    output.append(" : " + instanceOf);
                }
            }
            if ((subrelationOfs = (Set)statements.get("L0.SubrelationOf")) != null) {
                for (String subrelationOf : subrelationOfs) {
                    output.append(" <R " + subrelationOf);
                }
            }
            if ((inherits = (Set)statements.get("L0.Inherits")) != null) {
                for (String inherit : inherits) {
                    output.append(" <T " + inherit);
                }
            }
            output.append("\n");
        }
        if (info.newResource) {
            output.append("  @L0.new\n");
        }
        for (Map.Entry entry : statements.entrySet()) {
            String predicate = (String)entry.getKey();
            if (this.ignoreIdentifiers && predicate.equals("L0.identifier") || "L0.InstanceOf".equals(predicate) || "L0.SubrelationOf".equals(predicate) || "L0.Inherits".equals(predicate) || "L0.PartOf".equals(predicate)) continue;
            if (predicate.startsWith("blan")) {
                predicate = this.getBlankRewrite(predicate);
            }
            Set objects = (Set)entry.getValue();
            PrettyPrintTG.indent(output, indent + 1);
            if (objects.size() == 1) {
                output.append(predicate + " " + (String)objects.iterator().next() + "\n");
                continue;
            }
            output.append(predicate + "\n");
            for (String object : objects) {
                PrettyPrintTG.indent(output, indent + 1);
                output.append("  " + object + "\n");
            }
        }
        TreeMap<String, TreeSet<Integer>> ownedOrdered = new TreeMap<String, TreeSet<Integer>>();
        int i3 = 0;
        while (i3 < info.owned.size()) {
            String predicateURI3 = this.rewritePredicateURI(info.owned.get(i3));
            TreeSet<Integer> owneds = (TreeSet<Integer>)ownedOrdered.get(predicateURI3);
            if (owneds == null) {
                owneds = new TreeSet<Integer>();
                ownedOrdered.put(predicateURI3, owneds);
            }
            owneds.add(info.owned.get(i3 + 1));
            i3 += 2;
        }
        for (Map.Entry entry : ownedOrdered.entrySet()) {
            String predicateURI4 = (String)entry.getKey();
            Set owneds = (Set)entry.getValue();
            Iterator iterator = owneds.iterator();
            while (iterator.hasNext()) {
                int owned = (Integer)iterator.next();
                ResourceInfo ownedInfo = (ResourceInfo)this.infos.get(owned);
                String blank = this.printBlank(predicateURI4, ownedInfo, indent + 1);
                if (blank == null) continue;
                output.append(blank);
            }
        }
        return output.toString();
    }

    void prettyPrint() throws Exception {
        String uri;
        PrettyPrintTG.log("Starting prettyPrint for TransferableGraph with {} resources, {} identities, {} statements and {} values", this.query.getGraph().resourceCount, this.query.getGraph().identities, this.query.getGraph().statements.length, this.query.getGraph().values.length);
        this.query.forIdentities((TObjectProcedure<Identity>)((TObjectProcedure)id -> {
            int identityResource = id.resource;
            if (id.definition instanceof Internal) {
                Internal internal = (Internal)id.definition;
                Identity parent = this.query.getIdentity(internal.parent);
                if (parent.definition instanceof External || parent.definition instanceof Root) {
                    PrettyPrintTG.log("Resolving internal identity {}", id);
                    String name = "BASE";
                    ResourceInfo info = new ResourceInfo(true, name, identityResource, -1);
                    info.aliasURI = this.query.getURI(identityResource);
                    info.newResource = true;
                    this.orderedInfos.put(name, info);
                    PrettyPrintTG.log("    which parent is external {} and has an aliasURI {}", parent, info.aliasURI);
                    for (Identity child : this.query.getChildren((Identity)id)) {
                        this.recurseURI(this.orderedInfos, child, name, identityResource);
                    }
                    PrettyPrintTG.log("    and has {} children", this.infos.size());
                }
            } else if (id.definition instanceof External) {
                External ext = (External)id.definition;
                if (ext.name.contains("@")) {
                    PrettyPrintTG.log("Detected an external shared library {}", ext);
                    int index = ext.name.indexOf(64);
                    String prefix = ext.name.substring(0, index);
                    int index2 = ext.name.indexOf(47, index);
                    if (index2 == -1) {
                        String cfr_ignored_0 = ext.name;
                    } else {
                        ext.name.substring(0, index2);
                    }
                    String uri = this.query.getURI(identityResource);
                    PrettyPrintTG.log("    which was resolved as URI={} and prefix={}", uri, prefix);
                    this.ontologies.put(uri, prefix);
                } else if (ext.name.contains("-")) {
                    PrettyPrintTG.log("Resolving possible ontology {}", ext);
                    String uri = this.query.getURI(identityResource);
                    Matcher m = this.versionExtractPattern.matcher(uri);
                    if (m.matches() && !this.ontologies.containsKey(uri)) {
                        int index = ext.name.indexOf(45);
                        String prefix = ext.name.substring(0, index);
                        PrettyPrintTG.log("    and it was resolved as URI={} and prefix {}", uri, prefix);
                        this.ontologies.put(uri, prefix);
                    }
                }
            }
            return true;
        }));
        PrettyPrintTG.log("Discovering other resources..", new Object[0]);
        TIntArrayList todo = new TIntArrayList();
        for (final ResourceInfo info : this.orderedInfos.values()) {
            todo.add(info.resource);
            this.infos.put(info.resource, (Object)info);
        }
        while (!todo.isEmpty()) {
            int resource = todo.removeAt(todo.size() - 1);
            this.discoverBlank(resource, todo);
        }
        for (final ResourceInfo info : this.infos.valueCollection()) {
            this.discoverOwners(info);
        }
        for (final ResourceInfo info : this.infos.valueCollection()) {
            if (!info.ownedResourcesWithPredicates.isEmpty() && info.ownedResourcesWithPredicates.size() == 1) {
                info.ownedResourcesWithPredicates.forEachEntry(new TIntIntProcedure(){

                    public boolean execute(int owner, int predicate) {
                        ResourceInfo ownerInfo = (ResourceInfo)PrettyPrintTG.this.infos.get(owner);
                        ownerInfo.owned.add(predicate);
                        ownerInfo.owned.add(info.resource);
                        return false;
                    }
                });
                continue;
            }
            System.err.println("Here we are with " + String.valueOf(info));
        }
        for (final ResourceInfo info : this.infos.valueCollection()) {
            int i = 0;
            while (i < info.owned.size()) {
                int object = info.owned.get(i + 1);
                ResourceInfo inf = (ResourceInfo)this.infos.get(object);
                if (inf != null) {
                    info.ownedBy.remove(inf);
                }
                i += 2;
            }
        }
        Identity routeGraphConn = this.query.findExternalByURI("http://www.simantics.org/Diagram-2.2/RouteGraphConnection");
        Identity instanceOf = this.query.findExternalByURI("http://www.simantics.org/Layer0-1.1/InstanceOf");
        Identity diagramConnetionToConnection = this.query.findExternalByURI("http://www.simantics.org/Modeling-1.2/DiagramConnectionToConnection");
        Identity elemTo = this.query.findExternalByURI("http://www.simantics.org/Modeling-1.2/ElementToComponent");
        for (ResourceInfo infoo : this.infos.valueCollection()) {
            int instOf;
            int elemToComponent;
            if (elemTo != null && (elemToComponent = this.query.getPossibleObject(infoo.resource, elemTo)) != -2) {
                Identity component = this.query.getIdentity(elemToComponent);
                Identity internal = this.query.getIdentity(infoo.resource);
                if (internal.definition instanceof Internal && component.definition instanceof Internal) {
                    Internal iComponent = (Internal)component.definition;
                    infoo.name = infoo.name.substring(0, infoo.name.lastIndexOf(".") + 1) + iComponent.name;
                }
            }
            if (instanceOf == null || (instOf = this.query.getPossibleObject(infoo.resource, instanceOf)) == -2 || routeGraphConn == null || instOf != routeGraphConn.resource) continue;
            int connection = this.query.getPossibleObject(infoo.resource, diagramConnetionToConnection);
            if (connection != -2) {
                ArrayList<CallSite> nameParts = new ArrayList<CallSite>();
                TIntArrayList statements = this.query.getStatements(connection);
                int i = 0;
                while (i < statements.size()) {
                    int n = statements.get(i);
                    Identity possibleInverse = this.query.getIdentity(n);
                    if (possibleInverse != null) {
                        int inverseRelation = -2;
                        int parentId = -2;
                        if (possibleInverse.definition instanceof Internal) {
                            Internal iPossibleInverse = (Internal)possibleInverse.definition;
                            if (iPossibleInverse.name.equals("Inverse")) {
                                inverseRelation = this.query.getPossibleObject(connection, possibleInverse);
                                parentId = iPossibleInverse.parent;
                            } else {
                                PrettyPrintTG.log("Unsupported inverse relation found for {} {}", infoo, iPossibleInverse);
                            }
                        } else if (possibleInverse.definition instanceof External) {
                            External ePossibleInverse = (External)possibleInverse.definition;
                            if (ePossibleInverse.name.equals("Inverse")) {
                                inverseRelation = this.query.getPossibleObject(connection, possibleInverse);
                                parentId = ePossibleInverse.parent;
                            } else {
                                PrettyPrintTG.log("This external inverse is unsupported for {} {}", infoo, ePossibleInverse);
                            }
                        } else {
                            PrettyPrintTG.log("This type of definition is not supported {}", infoo);
                        }
                        if (inverseRelation != -2) {
                            String parentName;
                            String objectName;
                            Identity object = this.query.getIdentity(inverseRelation);
                            Identity parent = this.query.getIdentity(parentId);
                            if (object.definition instanceof Internal) {
                                objectName = ((Internal)object.definition).name;
                            } else if (object.definition instanceof External) {
                                objectName = ((External)object.definition).name;
                            } else {
                                PrettyPrintTG.log("This type of definition is not supported {}", infoo);
                                throw new Error("UNSUPPORTED " + String.valueOf(infoo));
                            }
                            if (parent.definition instanceof Internal) {
                                parentName = ((Internal)parent.definition).name;
                            } else if (parent.definition instanceof External) {
                                parentName = ((External)parent.definition).name;
                            } else {
                                PrettyPrintTG.log("This type of definition is not supported {}", infoo);
                                throw new Error("UNSUPPORTED " + String.valueOf(infoo));
                            }
                            String fullName = parentName + "_" + objectName;
                            nameParts.add((CallSite)((Object)fullName));
                        } else {
                            PrettyPrintTG.log("No inverse relation found for {}", infoo);
                        }
                    } else {
                        PrettyPrintTG.log("Did not find possible inverse relation for {}", infoo);
                    }
                    i += 2;
                }
                nameParts.sort((o1, o2) -> o1.compareTo((String)o2));
                Object name = "";
                for (String string : nameParts) {
                    name = (String)name + string;
                }
                infoo.name = infoo.name.substring(0, infoo.name.lastIndexOf(".") + 1) + (String)name;
                continue;
            }
            LOGGER.error("Could not find connection for " + String.valueOf(infoo) + ". Statements of graph below");
            LOGGER.error("Subject -> Predicate : " + infoo.resource + " -> " + diagramConnetionToConnection.resource);
        }
        for (ResourceInfo info : this.infos.valueCollection()) {
            if (!info.name.startsWith("blank")) continue;
            info.name = "blank" + this.findHash(info);
        }
        TreeMap<String, ResourceInfo> order = new TreeMap<String, ResourceInfo>();
        for (ResourceInfo info : this.infos.valueCollection()) {
            order.put(info.name, info);
        }
        for (ResourceInfo info : order.values()) {
            String uri2 = this.printURI(info, true, 0, false);
            if (uri2 == null) continue;
            this.output.append(uri2);
        }
        TreeMap<String, ResourceInfo> rblanks = new TreeMap<String, ResourceInfo>();
        for (ResourceInfo info : order.values()) {
            if (info.hasURI || info.ownedResourcesWithPredicates.size() == 1) continue;
            if (info.name.startsWith("blank")) {
                rblanks.put(this.getBlankRewrite(info.name), info);
                continue;
            }
            uri = this.printURI(info, false, 0, false);
            if (uri == null) continue;
            this.output.append(uri);
        }
        for (ResourceInfo info : rblanks.values()) {
            if (info.hasURI || info.ownedResourcesWithPredicates.size() == 1 || (uri = this.printURI(info, false, 0, false)) == null) continue;
            this.output.append(uri);
        }
        StringBuilder refs = new StringBuilder();
        for (String ontology : this.referencedOntologies) {
            String key = this.ontologies.get(ontology);
            refs.append(key + " = <" + ontology + ">\n");
        }
        if (!this.referencedOntologies.isEmpty()) {
            refs.append("\n");
        }
        this.output.insert(0, refs.toString());
    }

    private String calculateHash(ResourceInfo info) {
        StringBuilder statementHash = new StringBuilder();
        TreeSet<Object> parts = new TreeSet<Object>();
        int i = 0;
        while (i < info.owned.size()) {
            int predicate = info.owned.get(i);
            int n = info.owned.get(i + 1);
            String predicatee = this.rewritePredicateURI(predicate);
            ResourceInfo objInfo = (ResourceInfo)this.infos.get(n);
            parts.add(predicatee + "->" + objInfo.name + ";;;");
            i += 2;
        }
        List filtered = info.ownedBy.stream().filter(ri -> !ri.name.startsWith("blank")).collect(Collectors.toList());
        for (ResourceInfo ownedBy : filtered) {
            parts.add(ownedBy.name);
        }
        ResourceInfo parentInfo = (ResourceInfo)this.infos.get(info.parent);
        if (parentInfo != null && !parentInfo.name.startsWith("blank")) {
            parts.add("parent" + parentInfo.name);
        }
        for (String string : parts) {
            statementHash.append(string);
        }
        String string = this.makeHash(statementHash.toString().getBytes());
        return string;
    }

    private String findHash(ResourceInfo info) {
        if (info.name.startsWith("blank")) {
            String oldName;
            String hash = (String)this.hashes.get((Object)info.name);
            if (hash == null && this.hashes.put((Object)(oldName = info.name), (Object)(hash = this.calculateHash(info))) != null) {
                System.err.println("!!!!A clash occured for " + String.valueOf(info) + " with hash " + hash);
            }
            return hash;
        }
        return info.name;
    }

    public static String print(TransferableGraph1 tg, boolean ignoreIdentifiers) throws Exception {
        StringBuilder b = new StringBuilder();
        new PrettyPrintTG(tg, b, ignoreIdentifiers).prettyPrint();
        return b.toString();
    }

    public static void main(String[] args) throws Exception {
        Path output;
        Path input;
        if (args.length < 1) {
            System.out.println("Required arguments: <input .sharedOntology file> [<output .tg file>]");
        }
        if (args.length < 2) {
            input = Paths.get(args[0], new String[0]);
            output = input.getParent().resolve(String.valueOf(input.getName(input.getNameCount() - 1)) + ".fixed");
        } else {
            input = Paths.get(args[0], new String[0]);
            output = Paths.get(args[1], new String[0]);
        }
        System.out.format("Converting exported shared ontology%n\t" + input.toString() + "%nto bundle-compatible ontology%n\t" + output.toString(), new Object[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(input, new OpenOption[0]), 131072);){
            DataInputStream dis = new DataInputStream(is);
            DataContainer container = DataContainers.readFile((DataInput)dis);
            Binding binding = TransferableGraph1.BINDING;
            TransferableGraph1 graph = (TransferableGraph1)container.content.getValue(binding);
            new PrettyPrintTG(graph).prettyPrint();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void log(String string, Object ... args) {
        LOGGER.isDebugEnabled();
    }

    static class ResourceInfo {
        final boolean hasURI;
        String name;
        final int resource;
        boolean newResource = false;
        int parent;
        boolean inlined = false;
        Set<ResourceInfo> ownedBy = new HashSet<ResourceInfo>();
        TIntIntHashMap ownedResourcesWithPredicates = new TIntIntHashMap();
        String aliasURI = null;
        TIntArrayList owned = new TIntArrayList();

        public ResourceInfo(boolean hasURI, String name, int resource, int parent) {
            this.hasURI = hasURI;
            this.name = name;
            this.resource = resource;
            this.parent = parent;
        }

        public String toString() {
            return this.name + (String)(this.aliasURI != null ? " = <" + this.aliasURI + ">" : "");
        }
    }
}

