/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graph.representation;

/**
 * A part of TransferableGraph data structure. 
 * Gives an identity to a resource.
 * @author Hannu Niemist�
 */
public class Identity {
	public int resource;
	public IdentityDefinition definition;
	
	public Identity() {
	}

	public Identity(int resource, IdentityDefinition definition) {
		this.resource = resource;
		this.definition = definition;
	}
	
	@Override
	public String toString() {
	    return "#" + resource + " = " + definition;
	}
}
