package org.simantics.graph.query;

import org.simantics.databoard.util.URIStringUtils;

public class UriUtils {

	public static Path uriToPath(String uri) {
		String[] segments;
		Path cur;
		if(uri.startsWith("http:/")) {
			if(uri.length() == 6)
				return Paths.Root;
			segments = uri.substring(7).split("/");
			cur = Paths.Root;
		}
		else {
			int p = uri.indexOf('/');
			if(p == -1)
				return new PathRoot(uri);
			else {
				segments = uri.substring(p+1).split("/");
				cur = new PathRoot(uri.substring(0, p));
			}
		}

		for(String segment : segments)
			cur = new PathChild(segment, cur);
		return cur;
	}
	
	public static Path uriToPathUnescaped(String uri) {
		String[] segments;
		Path cur;
		if(uri.startsWith("http:/")) {
			if(uri.length() == 6)
				return Paths.Root;
			segments = uri.substring(7).split("/");
			cur = Paths.Root;
		}
		else {
			int p = uri.indexOf('/');
			if(p == -1)
				return new PathRoot(URIStringUtils.unescape(uri));
			else {
				segments = uri.substring(p+1).split("/");
				cur = new PathRoot(URIStringUtils.unescape(uri.substring(0, p)));
			}
		}

		for(String segment : segments)
			cur = new PathChild(URIStringUtils.unescape(segment), cur);
		return cur;
	}
	
}
