/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;
import org.simantics.layer0.Layer0;

public class VirtualGraphExport {
    ReadGraph g;
    VirtualGraph vg;
    VirtualGraphSupport vgs;
    Layer0 L0;
    THashSet<Resource> nameResources = new THashSet();
    THashMap<Resource, String> names = new THashMap();
    TObjectIntHashMap<Resource> resourceIds = new TObjectIntHashMap();
    ArrayList<Identity> identities = new ArrayList();
    ArrayList<Value> values = new ArrayList();
    TIntArrayList statements = new TIntArrayList();

    private VirtualGraphExport(ReadGraph g, VirtualGraph vg) {
        this.g = g;
        this.vg = vg;
        this.vgs = (VirtualGraphSupport)g.getService(VirtualGraphSupport.class);
        this.L0 = Layer0.getInstance((ReadGraph)g);
    }

    private void processNames() throws DatabaseException {
        for (Statement stat : this.vgs.listStatements(this.vg)) {
            Resource p = stat.getPredicate();
            if (!p.equals(this.L0.HasName)) continue;
            Resource s = stat.getSubject();
            Resource o = stat.getObject();
            this.names.put((Object)s, (Object)((String)this.g.getValue(o)));
            this.nameResources.add((Object)o);
        }
    }

    private void prepareResource(Resource resource) throws DatabaseException {
        if (!this.resourceIds.containsKey((Object)resource)) {
            Resource parent;
            int newId = this.resourceIds.size();
            this.resourceIds.put((Object)resource, newId);
            String name = (String)this.names.get((Object)resource);
            if (name != null && (parent = this.g.getPossibleObject(resource, this.L0.PartOf)) != null) {
                this.prepareResource(parent);
                int parentId = this.resourceIds.get((Object)parent);
                External def = resource.isPersistent() ? new External(parentId, name) : new Internal(parentId, name);
                this.identities.add(new Identity(newId, (IdentityDefinition)def));
            }
        }
    }

    private void processStatements() throws DatabaseException {
        for (Statement stat : this.vgs.listStatements(this.vg)) {
            Resource o;
            Resource p;
            Resource s = stat.getSubject();
            if (this.nameResources.contains((Object)s) || (p = stat.getPredicate()).equals(this.L0.PartOf) || p.equals(this.L0.ConsistsOf) || p.equals(this.L0.HasName) || p.equals(this.L0.NameOf) || this.nameResources.contains((Object)(o = stat.getObject()))) continue;
            this.prepareResource(s);
            this.prepareResource(p);
            this.prepareResource(o);
            this.statements.add(this.resourceIds.get((Object)s));
            this.statements.add(this.resourceIds.get((Object)p));
            this.statements.add(-1);
            this.statements.add(this.resourceIds.get((Object)o));
        }
    }

    private void processValues() throws DatabaseException {
        for (Resource resourceWithValue : this.vgs.listValues(this.vg)) {
            if (this.nameResources.contains((Object)resourceWithValue)) continue;
            Binding binding = Bindings.getBeanBinding((Datatype)this.g.getDataType(resourceWithValue));
            Object value = this.g.getValue(resourceWithValue, binding);
            this.values.add(new Value(this.resourceIds.get((Object)resourceWithValue), new Variant(binding, value)));
        }
    }

    private TransferableGraph1 getTransferableGraph() {
        return new TransferableGraph1(this.resourceIds.size(), this.identities.toArray(new Identity[this.identities.size()]), this.statements.toArray(), this.values.toArray(new Value[this.values.size()]));
    }

    public static TransferableGraph1 export(ReadGraph g, VirtualGraph vg) throws DatabaseException {
        VirtualGraphExport export = new VirtualGraphExport(g, vg);
        export.processNames();
        export.processStatements();
        export.processValues();
        return export.getTransferableGraph();
    }
}

