/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

import java.io.Closeable;
import java.io.DataInput;
import java.util.TreeMap;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Value;

public interface TransferableGraphSource
extends Closeable {
    public static final byte TAG_RAW_COPY_VARIANT_VALUE = 1;
    public static final byte TAG_POTENTIALLY_MODIFIED_VARIANT_VALUE = 2;

    public DataContainer getHeader() throws Exception;

    public TreeMap<String, Variant> getExtensions() throws Exception;

    public int getResourceCount() throws Exception;

    public void init(ReadGraph var1) throws Exception;

    public int getIdentityCount() throws Exception;

    public void forIdentities(ReadGraph var1, TransferableGraphSourceProcedure<Identity> var2) throws Exception;

    public int getStatementCount() throws Exception;

    public void forStatements(ReadGraph var1, TransferableGraphSourceProcedure<int[]> var2) throws Exception;

    public int getValueCount() throws Exception;

    public void forValues(ReadGraph var1, TransferableGraphSourceProcedure<Value> var2) throws Exception;

    public void forValues2(ReadGraph var1, TransferableGraphSourceValueProcedure var2) throws Exception;

    public void reset() throws Exception;

    @FunctionalInterface
    public static interface TransferableGraphSourceProcedure<T> {
        public void execute(T var1) throws Exception;
    }

    public static interface TransferableGraphSourceValueProcedure {
        public void execute(int var1, Datatype var2, DataInput var3) throws Exception;

        public void rawCopy(int var1, int var2, DataInput var3) throws Exception;
    }
}

