/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.graph.db.StreamingTransferableGraphFileReader;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.PathChild;
import org.simantics.graph.query.TransferableGraphConversion;
import org.simantics.graph.query.UriUtils;
import org.simantics.graph.refactoring.GraphRefactoringUtils;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;
import org.simantics.graph.store.IdentityStore;
import org.simantics.utils.datastructures.BijectionMap;

public class AdaptingTransferableGraphFileReader
extends StreamingTransferableGraphFileReader {
    Map<String, String> identityMap = new HashMap<String, String>();
    Set<String> ignoreSet = new HashSet<String>();

    public AdaptingTransferableGraphFileReader(File file, boolean deleteOnClose) throws Exception {
        super(file, deleteOnClose);
    }

    public AdaptingTransferableGraphFileReader(File file, int size) throws IOException {
        super(file, size);
    }

    public AdaptingTransferableGraphFileReader(File file) throws Exception {
        super(file);
    }

    public AdaptingTransferableGraphFileReader(InputStream stream, int size) throws IOException {
        super(stream, size);
    }

    public AdaptingTransferableGraphFileReader(InputStream stream) throws Exception {
        super(stream);
    }

    public AdaptingTransferableGraphFileReader(ReadableByteChannel channel, int size) throws IOException {
        super(channel, size);
    }

    public AdaptingTransferableGraphFileReader(ReadableByteChannel channel) throws Exception {
        super(channel);
    }

    @Override
    public TransferableGraphSource readTG() throws Exception {
        if (this.getSize() == 0) {
            return null;
        }
        return new AdaptingFileTransferableGraphSource();
    }

    public void setIdentityMap(Map<String, String> identityMap) {
        this.identityMap = identityMap;
    }

    public void setIgnoreSet(Set<String> ignoreSet) {
        this.ignoreSet = ignoreSet;
    }

    public static void unfixIncorrectRoot(List<Identity> ids) {
        int i = 0;
        while (i < ids.size()) {
            Identity id = ids.get(i);
            if (id.definition instanceof Root) {
                Root root = (Root)id.definition;
                if (root.name.equals("") && root.type.equals("")) {
                    id.definition = new External(-1, "http:/");
                    return;
                }
            }
            ++i;
        }
    }

    class AdaptingFileTransferableGraphSource
    extends StreamingTransferableGraphFileReader.FileTransferableGraphSource {
        boolean init;
        List<Identity> newIdentities;
        int maxId;
        int oldIdentitiesCount;
        Set<Integer> toIgnore;
        Map<Integer, Integer> toSwap;

        public AdaptingFileTransferableGraphSource() throws Exception {
            super(AdaptingTransferableGraphFileReader.this);
            this.maxId = 0;
            this.toIgnore = new HashSet<Integer>();
            this.toSwap = new HashMap<Integer, Integer>();
            this.init = AdaptingTransferableGraphFileReader.this.identityMap.size() <= 0 && AdaptingTransferableGraphFileReader.this.ignoreSet.size() <= 0;
        }

        @Override
        public void init(ReadGraph graph) throws Exception {
            if (this.init) {
                return;
            }
            final ArrayList<Identity> oldIdentities = new ArrayList<Identity>();
            super.getIdentityCount();
            super.forIdentities(graph, new TransferableGraphSource.TransferableGraphSourceProcedure<Identity>(){

                @Override
                public void execute(Identity value) throws Exception {
                    oldIdentities.add(value);
                    AdaptingFileTransferableGraphSource.this.maxId = Math.max(AdaptingFileTransferableGraphSource.this.maxId, value.resource);
                }
            });
            ++this.maxId;
            TransferableGraph1 tg1 = new TransferableGraph1(oldIdentities.size(), oldIdentities.toArray(new Identity[0]), new int[0], new Value[0]);
            boolean fixed = GraphRefactoringUtils.fixIncorrectRoot((Identity[])tg1.identities);
            this.initInstructions(tg1, oldIdentities);
            if (fixed) {
                AdaptingTransferableGraphFileReader.unfixIncorrectRoot(this.newIdentities);
            }
            this.oldIdentitiesCount = oldIdentities.size();
            oldIdentities.clear();
            this.init = true;
        }

        private void initInstructions(TransferableGraph1 tg1, List<Identity> oldIdentities) {
            BijectionMap idMap = new BijectionMap();
            IdentityStore oldIdStore = TransferableGraphConversion.extractIdentities((TransferableGraph1)tg1);
            this.newIdentities = new ArrayList<Identity>();
            IdentityStore newIdStore = new IdentityStore();
            String[] stringArray = oldIdStore.getRoots();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                int id = oldIdStore.pathToId(UriUtils.uriToPath((String)s));
                Identity oldRoot = this.getIdentity(oldIdentities, id);
                newIdStore.defineRoot(s, id);
                Identity identity = new Identity();
                identity.resource = id;
                identity.definition = new Root(s, ((Root)oldRoot.definition).type);
                this.newIdentities.add(identity);
                idMap.map((Object)this.getIdentity(oldIdentities, id), (Object)identity);
                ++n2;
            }
            for (Map.Entry<String, String> entry : AdaptingTransferableGraphFileReader.this.identityMap.entrySet()) {
                Identity id;
                Path from = UriUtils.uriToPath((String)entry.getKey());
                Path to = UriUtils.uriToPath((String)entry.getValue());
                int fromId = oldIdStore.pathToId(from);
                if (fromId < 0) continue;
                int toId = oldIdStore.pathToId(to);
                if (toId > 0) {
                    id = this.getIdentity(oldIdentities, fromId);
                    Identity id2 = this.getIdentity(oldIdentities, toId);
                    idMap.map((Object)id, (Object)id2);
                    this.toSwap.put(fromId, toId);
                    continue;
                }
                id = this.getIdentity(oldIdentities, fromId);
                ArrayList<Path> parentPaths = new ArrayList<Path>();
                Path current = to;
                while (true) {
                    Path parent = ((PathChild)current).parent;
                    int parentId = oldIdStore.pathToId(parent);
                    parentPaths.add(0, parent);
                    if (parentId > 0) break;
                    current = parent;
                }
                Identity parentParent = this.getIdentity(oldIdentities, oldIdStore.pathToId((Path)parentPaths.get(0)));
                int i = 1;
                while (i < parentPaths.size()) {
                    Path parent = (Path)parentPaths.get(i);
                    String name = ((PathChild)parent).name;
                    Identity pid = null;
                    pid = this.getIdentity(this.newIdentities, newIdStore.pathToId((Path)parentPaths.get(i)));
                    if (pid == null) {
                        if (!newIdStore.hasIdentity(parentParent.resource)) {
                            Path currParent;
                            int parentId;
                            ArrayList<Identity> toCopy = new ArrayList<Identity>();
                            ArrayList<Path> toCopyPath = new ArrayList<Path>();
                            Identity curr = parentParent;
                            Path currPath = oldIdStore.idToPath(parentParent.resource);
                            toCopy.add(curr);
                            toCopyPath.add(currPath);
                            while (true) {
                                if ((parentId = newIdStore.pathToId(currParent = ((PathChild)toCopyPath.get((int)0)).parent)) > 0) break;
                                toCopy.add(0, this.getIdentity(oldIdentities, parentId));
                                toCopyPath.add(0, currParent);
                            }
                            toCopy.add(0, this.getIdentity(this.newIdentities, parentId));
                            toCopyPath.add(0, currParent);
                            int j = 1;
                            while (j < toCopy.size()) {
                                Identity _id = (Identity)toCopy.get(i);
                                this.newIdentities.add(_id);
                                int parId = newIdStore.pathToId((Path)toCopyPath.get(i - 1));
                                newIdStore.defineChild(parId, ((External)_id.definition).name, _id.resource);
                                ++j;
                            }
                        }
                        pid = new Identity();
                        pid.definition = new External(parentParent.resource, name);
                        ++this.maxId;
                        pid.resource = pid.resource;
                        this.newIdentities.add(pid);
                        newIdStore.defineChild(parentParent.resource, name, pid.resource);
                        parentParent = pid;
                    }
                    ++i;
                }
                Identity newId = new Identity();
                newId.definition = new External(parentParent.resource, ((PathChild)to).name);
                ++this.maxId;
                newId.resource = newId.resource;
                this.newIdentities.add(newId);
                idMap.map((Object)id, (Object)newId);
                this.toSwap.put(id.resource, newId.resource);
            }
            for (String uri : AdaptingTransferableGraphFileReader.this.ignoreSet) {
                Path from = UriUtils.uriToPath((String)uri);
                int fromId = oldIdStore.pathToId(from);
                if (fromId < 0) continue;
                this.toIgnore.add(fromId);
            }
            for (Identity oldId : oldIdentities) {
                if (idMap.containsLeft((Object)oldId) || this.newIdentities.contains(oldId) || this.toIgnore.contains(oldId.resource) || this.toSwap.containsKey(oldId.resource)) continue;
                this.newIdentities.add(oldId);
            }
        }

        private Identity getIdentity(List<Identity> identities, int id) {
            for (Identity identity : identities) {
                if (identity.resource != id) continue;
                return identity;
            }
            return null;
        }

        int[] filter(int[] stm) {
            int i = 0;
            while (i < 4) {
                if (this.toIgnore.contains(stm[i])) {
                    stm[i] = -1;
                } else {
                    Integer i2 = this.toSwap.get(stm[i]);
                    if (i2 != null) {
                        stm[i] = i2;
                    }
                }
                ++i;
            }
            return stm;
        }

        @Override
        public int getIdentityCount() throws Exception {
            if (!this.init) {
                return super.getIdentityCount();
            }
            int c = super.getIdentityCount();
            c -= this.oldIdentitiesCount;
            return c += this.newIdentities.size();
        }

        @Override
        public void forIdentities(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<Identity> procedure) throws Exception {
            for (Identity id : this.newIdentities) {
                procedure.execute(id);
            }
        }

        @Override
        public void forStatements(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<int[]> procedure) throws Exception {
            int[] value = new int[4];
            int stmLength = this.getStatementCount();
            int stmIndex = 0;
            while (stmIndex < stmLength) {
                value[stmIndex & 3] = AdaptingTransferableGraphFileReader.this.safeInt();
                if ((++stmIndex & 3) == 0) {
                    procedure.execute(value);
                }
                int avail = 262144 - AdaptingTransferableGraphFileReader.this.byteIndex >> 2;
                int allowed = Math.min(stmLength - stmIndex, avail);
                int index = AdaptingTransferableGraphFileReader.this.byteIndex;
                int i = 0;
                while (i < allowed) {
                    value[stmIndex & 3] = (AdaptingTransferableGraphFileReader.this.bytes[index++] & 0xFF) << 24 | (AdaptingTransferableGraphFileReader.this.bytes[index++] & 0xFF) << 16 | (AdaptingTransferableGraphFileReader.this.bytes[index++] & 0xFF) << 8 | AdaptingTransferableGraphFileReader.this.bytes[index++] & 0xFF;
                    if ((++stmIndex & 3) == 0 && (value = this.filter(value))[0] >= 0 && value[3] >= 0) {
                        if (value[1] >= 0) {
                            procedure.execute(value);
                        } else if (value[1] < 0 && value[2] >= 0) {
                            int t = value[0];
                            value[0] = value[3];
                            value[3] = t;
                            t = value[1];
                            value[1] = value[2];
                            value[2] = t;
                            procedure.execute(value);
                        }
                    }
                    ++i;
                }
                AdaptingTransferableGraphFileReader adaptingTransferableGraphFileReader = AdaptingTransferableGraphFileReader.this;
                adaptingTransferableGraphFileReader.byteIndex = adaptingTransferableGraphFileReader.byteIndex + (allowed << 2);
            }
        }

        @Override
        public void forValues(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceProcedure<Value> procedure) throws Exception {
            super.forValues(graph, procedure);
        }

        @Override
        public void forValues2(ReadGraph graph, TransferableGraphSource.TransferableGraphSourceValueProcedure procedure) throws Exception {
            super.forValues2(graph, procedure);
        }
    }
}

